/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.codehaus.janino.util.iterator.MultiDimensionalIterator;
import org.codehaus.janino.util.iterator.TransformingIterator;
import org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import org.codehaus.janino.util.resource.MultiResourceFinder;
import org.codehaus.janino.util.resource.ZipFileResourceFinder;

public class JarDirectoriesResourceFinder
extends LazyMultiResourceFinder {
    public JarDirectoriesResourceFinder(Iterator iterator) {
        super(JarDirectoriesResourceFinder.createIterator(iterator));
    }

    public JarDirectoriesResourceFinder(File[] fileArray) {
        this(Arrays.asList(fileArray).iterator());
    }

    private static Iterator createIterator(Iterator iterator) {
        return new MultiDimensionalIterator(new TransformingIterator(iterator){

            protected Object transform(Object object) {
                File[] fileArray = ((File)object).listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".jar");
                    }
                });
                return new TransformingIterator(Arrays.asList(fileArray).iterator()){

                    protected Object transform(Object object) {
                        try {
                            return new ZipFileResourceFinder(new ZipFile((File)object));
                        }
                        catch (IOException iOException) {
                            return MultiResourceFinder.EMPTY_RESOURCE_FINDER;
                        }
                    }
                };
            }
        }, 2);
    }
}

