/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.enumerator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.janino.util.enumerator.Enumerator;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;
import org.codehaus.janino.util.enumerator.EnumeratorSetTypeException;

public class EnumeratorSet {
    private final Class enumeratorClass;
    private final Set values;
    String optionalName = null;
    private static final Map namedEnumeratorSets = new HashMap();

    public EnumeratorSet(Class clazz) {
        this(clazz, new HashSet());
    }

    public EnumeratorSet(Class clazz, String string) throws EnumeratorFormatException {
        this(clazz, string, ",");
    }

    public EnumeratorSet(Class clazz, String string, String string2) throws EnumeratorFormatException {
        Set<Enumerator> set = new HashSet<Enumerator>();
        Map map = Enumerator.getInstances(clazz);
        Map map2 = EnumeratorSet.getNamedEnumeratorSets(clazz);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            Enumerator enumerator = (Enumerator)map.get(string3);
            if (enumerator != null) {
                set.add(enumerator);
                continue;
            }
            EnumeratorSet enumeratorSet = (EnumeratorSet)map2.get(string3);
            if (enumeratorSet != null) {
                if (set.isEmpty()) {
                    set = enumeratorSet.values;
                    this.optionalName = enumeratorSet.optionalName;
                    continue;
                }
                set.addAll(enumeratorSet.values);
                continue;
            }
            throw new EnumeratorFormatException(string3);
        }
        this.enumeratorClass = clazz;
        this.values = set;
    }

    private EnumeratorSet(Class clazz, Set set) {
        this.enumeratorClass = clazz;
        this.values = set;
    }

    public EnumeratorSet(Class clazz, boolean bl) {
        this(clazz, new HashSet());
        if (bl) {
            this.values.addAll(Enumerator.getInstances(clazz).values());
        }
    }

    public EnumeratorSet(EnumeratorSet enumeratorSet) {
        this(enumeratorSet.enumeratorClass, enumeratorSet.values);
    }

    public EnumeratorSet add(Enumerator enumerator) {
        if (enumerator.getClass() != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot add value of type \"" + enumerator.getClass() + "\" to set of different type \"" + this.enumeratorClass + "\"");
        }
        HashSet<Enumerator> hashSet = new HashSet<Enumerator>(this.values);
        hashSet.add(enumerator);
        return new EnumeratorSet(this.enumeratorClass, hashSet);
    }

    public EnumeratorSet add(EnumeratorSet enumeratorSet) {
        HashSet hashSet;
        if (enumeratorSet.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot add set of type \"" + enumeratorSet.enumeratorClass + "\" to set of different type \"" + this.enumeratorClass + "\"");
        }
        if (this.values.isEmpty()) {
            hashSet = enumeratorSet.values;
        } else if (enumeratorSet.values.isEmpty()) {
            hashSet = this.values;
        } else {
            hashSet = new HashSet(this.values);
            hashSet.addAll(enumeratorSet.values);
        }
        return new EnumeratorSet(this.enumeratorClass, hashSet);
    }

    public boolean contains(Enumerator enumerator) {
        if (enumerator.getClass() != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot check value of type \"" + enumerator.getClass() + "\" within set of different type \"" + this.enumeratorClass + "\"");
        }
        return this.values.contains(enumerator);
    }

    public boolean containsAllOf(EnumeratorSet enumeratorSet) {
        if (enumeratorSet.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot compare set of type \"" + enumeratorSet.enumeratorClass + "\" with set of different type \"" + this.enumeratorClass + "\"");
        }
        return this.values.containsAll(enumeratorSet.values);
    }

    public boolean containsAnyOf(EnumeratorSet enumeratorSet) {
        if (enumeratorSet.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot compare set of type \"" + enumeratorSet.enumeratorClass + "\" with set of different type \"" + this.enumeratorClass + "\"");
        }
        Iterator iterator = enumeratorSet.values.iterator();
        while (iterator.hasNext()) {
            if (!this.values.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof EnumeratorSet && this.values.equals(((EnumeratorSet)object).values);
    }

    private static Map getNamedEnumeratorSets(Class clazz) {
        HashMap hashMap = (HashMap)namedEnumeratorSets.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap();
            namedEnumeratorSets.put(clazz, hashMap);
        }
        return hashMap;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public EnumeratorSet remove(Enumerator enumerator) {
        if (enumerator.getClass() != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot remove value of type \"" + enumerator.getClass() + "\" from set of different type \"" + this.enumeratorClass + "\"");
        }
        if (!this.values.contains(enumerator)) {
            return this;
        }
        HashSet hashSet = new HashSet(this.values);
        hashSet.remove(enumerator);
        return new EnumeratorSet(this.enumeratorClass, hashSet);
    }

    public EnumeratorSet remove(EnumeratorSet enumeratorSet) {
        if (enumeratorSet.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot remove set of type \"" + enumeratorSet.enumeratorClass + "\" from set of different type \"" + this.enumeratorClass + "\"");
        }
        HashSet hashSet = new HashSet(this.values);
        hashSet.removeAll(enumeratorSet.values);
        return new EnumeratorSet(this.enumeratorClass, hashSet);
    }

    public EnumeratorSet setName(String string) {
        if (this.optionalName == string || this.optionalName != null && this.optionalName.equals(string)) {
            return this;
        }
        Map map = EnumeratorSet.getNamedEnumeratorSets(this.enumeratorClass);
        if (this.optionalName != null) {
            map.remove(this.optionalName);
        }
        this.optionalName = string;
        if (this.optionalName != null) {
            map.put(this.optionalName, this);
        }
        return this;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String string) {
        if (this.optionalName != null) {
            return this.optionalName;
        }
        Iterator iterator = this.values.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(((Enumerator)iterator.next()).name);
        while (iterator.hasNext()) {
            stringBuffer.append(string).append(((Enumerator)iterator.next()).name);
        }
        return stringBuffer.toString();
    }
}

