/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpHandlerNotDefinedException;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPacketHandler;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduBulk;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpPortal;
import org.opennms.protocols.snmp.SnmpRequest;
import org.opennms.protocols.snmp.SnmpResponseHandler;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimer;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public class SnmpSession {
    public static final int ERROR_TIMEOUT = -1;
    public static final int ERROR_IOEXCEPTION = -2;
    public static final int ERROR_ENCODING = -3;
    private LinkedList<SnmpRequest> m_requests;
    private SnmpPeer m_peer;
    private SnmpTimer m_timer;
    private SnmpHandler m_defHandler;
    AsnEncoder m_encoder;
    private Object m_sync;
    private boolean m_stopRun;
    private SnmpPortal m_portal;
    private boolean m_threadException;
    private Throwable m_why;

    private ByteArrayInfo encode(SnmpPduPacket pdu) throws SnmpPduEncodingException, AsnEncodingException {
        SnmpOctetString community;
        SnmpPeer peer = this.m_peer;
        SnmpParameters parms = peer.getParameters();
        int offset = 0;
        byte[] buf = new byte[16384];
        SnmpInt32 version = new SnmpInt32(parms.getVersion());
        offset = version.encodeASN(buf, offset, this.m_encoder);
        if (pdu.getCommand() == 163) {
            String wrComm = parms.getWriteCommunity();
            if (wrComm == null) {
                throw new SnmpPduEncodingException("Requested SET but there is no write community");
            }
            community = new SnmpOctetString(wrComm.getBytes());
        } else {
            community = new SnmpOctetString(parms.getReadCommunity().getBytes());
        }
        offset = community.encodeASN(buf, offset, this.m_encoder);
        int pivot = offset = pdu.encodeASN(buf, offset, this.m_encoder);
        offset = this.m_encoder.buildHeader(buf, offset, (byte)48, pivot);
        SnmpUtil.rotate(buf, 0, pivot, offset);
        return new ByteArrayInfo(buf, offset);
    }

    private ByteArrayInfo encode(SnmpPduTrap pdu) throws SnmpPduEncodingException, AsnEncodingException {
        SnmpPeer peer = this.m_peer;
        SnmpParameters parms = peer.getParameters();
        int offset = 0;
        byte[] buf = new byte[16384];
        SnmpInt32 version = new SnmpInt32(parms.getVersion());
        offset = version.encodeASN(buf, offset, this.m_encoder);
        SnmpOctetString community = new SnmpOctetString(parms.getReadCommunity().getBytes());
        offset = community.encodeASN(buf, offset, this.m_encoder);
        int pivot = offset = pdu.encodeASN(buf, offset, this.m_encoder);
        offset = this.m_encoder.buildHeader(buf, offset, (byte)48, pivot);
        SnmpUtil.rotate(buf, 0, pivot, offset);
        return new ByteArrayInfo(buf, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequest(SnmpRequest req) {
        LinkedList<SnmpRequest> linkedList = this.m_requests;
        synchronized (linkedList) {
            this.m_requests.addLast(req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRequest(SnmpRequest req) {
        LinkedList<SnmpRequest> linkedList = this.m_requests;
        synchronized (linkedList) {
            if (this.m_requests.size() > 0) {
                ListIterator<SnmpRequest> iter = this.m_requests.listIterator(0);
                while (iter.hasNext()) {
                    SnmpRequest cmp = iter.next();
                    if (!req.equals(cmp)) continue;
                    req.m_expired = true;
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnmpRequest findRequest(SnmpPduPacket pdu) {
        LinkedList<SnmpRequest> linkedList = this.m_requests;
        synchronized (linkedList) {
            if (this.m_requests.size() > 0) {
                ListIterator<SnmpRequest> iter = this.m_requests.listIterator(0);
                while (iter.hasNext()) {
                    SnmpRequest req = iter.next();
                    if (req.m_expired || !(req.m_pdu instanceof SnmpPduPacket) || ((SnmpPduPacket)req.m_pdu).getRequestId() != pdu.getRequestId()) continue;
                    return req;
                }
            }
        }
        return null;
    }

    SnmpTimer getTimer() {
        return this.m_timer;
    }

    void transmit(SnmpRequest req) throws SnmpPduEncodingException, AsnEncodingException, IOException {
        SnmpPduPacket pdu = null;
        SnmpPduTrap trap = null;
        SnmpPeer peer = this.m_peer;
        SnmpParameters parms = peer.getParameters();
        if (req.m_pdu instanceof SnmpPduPacket) {
            pdu = (SnmpPduPacket)req.m_pdu;
        }
        if (req.m_pdu instanceof SnmpPduTrap) {
            trap = (SnmpPduTrap)req.m_pdu;
        }
        if (pdu != null) {
            switch (pdu.getCommand()) {
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    if (parms.getVersion() >= 1) break;
                    throw new SnmpPduEncodingException("Cannot send pdu, invalid SNMP version");
                }
            }
            ByteArrayInfo msg = this.encode(pdu);
            if (pdu.getPeer() == null) {
                this.m_portal.send(this.m_peer, msg.array(), msg.size());
            } else {
                this.m_portal.send(pdu.getPeer(), msg.array(), msg.size());
            }
        } else if (trap != null) {
            ByteArrayInfo msg = this.encode(trap);
            this.m_portal.send(this.m_peer, msg.array(), msg.size());
        } else {
            throw new SnmpPduEncodingException("Invalid PDU type passed to method");
        }
    }

    public SnmpSession(InetAddress peer) throws SocketException {
        this.m_sync = new Object();
        this.m_requests = new LinkedList();
        this.m_peer = new SnmpPeer(peer);
        this.m_timer = new SnmpTimer();
        this.m_defHandler = null;
        this.m_stopRun = false;
        this.m_encoder = new SnmpParameters().getEncoder();
        this.m_portal = new SnmpPortal(new SessionHandler(), this.m_encoder, 0);
        this.m_threadException = false;
        this.m_why = null;
        this.m_timer.schedule(new CleanupRequest(), 1000L);
    }

    public SnmpSession(SnmpPeer peer) throws SocketException {
        this.m_requests = new LinkedList();
        this.m_timer = new SnmpTimer();
        this.m_defHandler = null;
        this.m_sync = new Object();
        this.m_stopRun = false;
        this.m_encoder = peer.getParameters().getEncoder();
        this.m_portal = new SnmpPortal(new SessionHandler(), this.m_encoder, peer.getServerPort());
        this.m_threadException = false;
        this.m_why = null;
        this.m_peer = peer;
        this.m_timer.schedule(new CleanupRequest(), 5000L);
    }

    public SnmpSession(InetAddress peer, SnmpParameters params) throws SocketException {
        this(peer);
        this.m_peer.setParameters(params);
    }

    public SnmpHandler getDefaultHandler() {
        return this.m_defHandler;
    }

    public void setDefaultHandler(SnmpHandler hdl) {
        this.m_defHandler = hdl;
    }

    public SnmpPeer getPeer() {
        return this.m_peer;
    }

    public void setPeer(SnmpPeer peer) {
        this.m_peer = peer;
        this.setAsnEncoder(peer.getParameters().getEncoder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstandingCount() {
        LinkedList<SnmpRequest> linkedList = this.m_sync;
        synchronized (linkedList) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        linkedList = this.m_requests;
        synchronized (linkedList) {
            if (this.m_requests.size() > 0) {
                ListIterator iter = this.m_requests.listIterator();
                while (iter.hasNext()) {
                    SnmpRequest req = (SnmpRequest)iter.next();
                    if (!req.m_expired) continue;
                    iter.remove();
                }
            }
            return this.m_requests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int requestId) {
        LinkedList<SnmpRequest> linkedList = this.m_sync;
        synchronized (linkedList) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        linkedList = this.m_requests;
        synchronized (linkedList) {
            if (this.m_requests.size() > 0) {
                ListIterator iter = this.m_requests.listIterator();
                while (iter.hasNext()) {
                    SnmpRequest req = (SnmpRequest)iter.next();
                    if (!req.m_expired && (!(req.m_pdu instanceof SnmpPduPacket) || ((SnmpPduPacket)req.m_pdu).getRequestId() != requestId)) continue;
                    req.m_expired = true;
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(SnmpPduPacket pdu, SnmpHandler handler) {
        if (handler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        SnmpRequest req = new SnmpRequest(this, pdu, handler);
        if (pdu.getCommand() != 167 || pdu.getPeer() == null) {
            this.addRequest(req);
        }
        req.run();
        if (req.m_expired) {
            return 0;
        }
        return ((SnmpPduPacket)req.m_pdu).getRequestId();
    }

    public int send(SnmpPduPacket pdu) {
        if (this.m_defHandler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        return this.send(pdu, this.m_defHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(SnmpPduTrap pdu, SnmpHandler handler) {
        if (handler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_stopRun) {
                throw new IllegalStateException("illegal operation, the session has been closed");
            }
        }
        SnmpRequest req = new SnmpRequest(this, pdu, handler);
        req.run();
        return 0;
    }

    public int send(SnmpPduTrap pdu) {
        if (this.m_defHandler == null) {
            throw new SnmpHandlerNotDefinedException("No Handler Defined");
        }
        return this.send(pdu, this.m_defHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.m_sync;
        synchronized (object) {
            return this.m_stopRun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList<SnmpRequest> linkedList = this.m_sync;
        synchronized (linkedList) {
            if (this.m_stopRun) {
                throw new IllegalStateException("The session is already closed");
            }
            this.m_stopRun = true;
            this.m_timer.cancel();
            this.m_portal.close();
        }
        linkedList = this.m_requests;
        synchronized (linkedList) {
            this.m_requests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raise() throws Throwable {
        Object object = this.m_sync;
        synchronized (object) {
            if (this.m_threadException) {
                throw this.m_why;
            }
        }
    }

    public void setAsnEncoder(AsnEncoder encoder) {
        this.m_encoder = encoder;
        this.m_portal.setAsnEncoder(encoder);
    }

    public AsnEncoder getAsnEncoder() {
        return this.m_encoder;
    }

    public static void registerSyntaxObject(SnmpSyntax object) {
        SnmpUtil.registerSyntax(object);
    }

    public SnmpSyntax getNext(SnmpObjectId oid) {
        return this.getResult(161, oid);
    }

    public SnmpSyntax[] getNext(SnmpObjectId[] oids) {
        return this.getResults(161, oids);
    }

    public SnmpSyntax get(SnmpObjectId oid) {
        return this.getResult(160, oid);
    }

    public SnmpSyntax set(SnmpObjectId oid, SnmpSyntax value) {
        return this.getResult(163, oid, value);
    }

    public SnmpSyntax[] set(SnmpObjectId[] oids, SnmpSyntax[] values) {
        return this.getResults(163, oids, values);
    }

    public SnmpSyntax[] get(SnmpObjectId[] oids) {
        return this.getResults(160, oids);
    }

    public SnmpSyntax[] getBulk(int nonRepeaters, int maxReptitions, SnmpObjectId id) {
        return this.getBulk(nonRepeaters, maxReptitions, new SnmpObjectId[]{id});
    }

    public SnmpSyntax[] getBulk(int nonRepeaters, int maxRepititions, SnmpObjectId[] oids) {
        SnmpVarBind[] varbinds = this.createVarBinds(oids);
        SnmpPduBulk request = new SnmpPduBulk(nonRepeaters, maxRepititions, varbinds);
        return this.getResults(request);
    }

    private SnmpSyntax getResult(int requestType, SnmpObjectId oid) {
        SnmpSyntax[] result = this.getResults(requestType, new SnmpObjectId[]{oid});
        return result == null || result.length <= 0 ? null : result[0];
    }

    private SnmpSyntax getResult(int requestType, SnmpObjectId oid, SnmpSyntax value) {
        SnmpSyntax[] result = this.getResults(requestType, new SnmpObjectId[]{oid}, new SnmpSyntax[]{oid});
        return result == null || result.length <= 0 ? null : result[0];
    }

    private SnmpSyntax[] getResults(int requestType, SnmpObjectId[] oids) {
        SnmpVarBind[] varbinds = this.createVarBinds(oids);
        SnmpPduRequest request = new SnmpPduRequest(requestType, varbinds);
        return this.getResults(request);
    }

    private SnmpSyntax[] getResults(int requestType, SnmpObjectId[] oids, SnmpSyntax[] values) {
        SnmpVarBind[] varbinds = this.createVarBinds(oids, values);
        SnmpPduRequest request = new SnmpPduRequest(requestType, varbinds);
        return this.getResults(request);
    }

    private SnmpVarBind[] createVarBinds(SnmpObjectId[] oids) {
        SnmpVarBind[] varbinds = new SnmpVarBind[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            varbinds[i] = new SnmpVarBind(oids[i]);
        }
        return varbinds;
    }

    private SnmpVarBind[] createVarBinds(SnmpObjectId[] oids, SnmpSyntax[] values) {
        SnmpVarBind[] varbinds = new SnmpVarBind[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            varbinds[i] = new SnmpVarBind(oids[i], values[i]);
        }
        return varbinds;
    }

    private SnmpSyntax[] getResults(SnmpPduPacket request) {
        SnmpPduPacket response = this.getResponse(request);
        if (response == null) {
            return null;
        }
        SnmpSyntax[] vals = new SnmpSyntax[response.getLength()];
        for (int i = 0; i < response.getLength(); ++i) {
            vals[i] = response.getVarBindAt(i).getValue();
        }
        return vals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnmpPduPacket getResponse(SnmpPduPacket request) {
        SnmpResponseHandler handler;
        SnmpResponseHandler snmpResponseHandler = handler = new SnmpResponseHandler();
        synchronized (snmpResponseHandler) {
            this.send(request, (SnmpHandler)handler);
            try {
                handler.wait((this.getPeer().getRetries() + 1) * this.getPeer().getTimeout());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        SnmpPduPacket response = handler.getResponse();
        return response;
    }

    private static class ByteArrayInfo {
        private byte[] m_buf;
        private int m_length;

        public ByteArrayInfo(byte[] buf, int length) {
            this.m_buf = buf;
            this.m_length = length;
        }

        public byte[] array() {
            return this.m_buf;
        }

        public int size() {
            return this.m_length;
        }
    }

    private class CleanupRequest
    implements Runnable {
        private CleanupRequest() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = SnmpSession.this.m_requests;
            synchronized (linkedList) {
                if (SnmpSession.this.m_requests.size() > 0) {
                    ListIterator iter = SnmpSession.this.m_requests.listIterator(0);
                    while (iter.hasNext()) {
                        SnmpRequest req = (SnmpRequest)iter.next();
                        if (!req.m_expired) continue;
                        iter.remove();
                    }
                }
            }
            if (!SnmpSession.this.m_stopRun && !SnmpSession.this.m_threadException) {
                SnmpSession.this.m_timer.schedule(this, 1000L);
            }
        }
    }

    private class SessionHandler
    implements SnmpPacketHandler {
        private SessionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processSnmpMessage(InetAddress agent, int port, SnmpInt32 version, SnmpOctetString community, int pduType, SnmpPduPacket pdu) throws SnmpPduEncodingException {
            boolean isExpired = false;
            SnmpRequest req = null;
            LinkedList linkedList = SnmpSession.this.m_requests;
            synchronized (linkedList) {
                req = SnmpSession.this.findRequest(pdu);
                if (req != null) {
                    isExpired = req.m_expired;
                }
            }
            if (!isExpired) {
                int cmd = -1;
                if (req != null && req.m_pdu instanceof SnmpPduPacket) {
                    cmd = ((SnmpPduPacket)req.m_pdu).getCommand();
                } else {
                    cmd = pdu.getCommand();
                    pdu.setPeer(new SnmpPeer(agent, port));
                }
                switch (cmd) {
                    case 163: {
                        String tst = new String(community.getString());
                        String wr = SnmpSession.this.m_peer.getParameters().getWriteCommunity();
                        if (tst.equals(wr)) break;
                        throw new SnmpPduEncodingException("Invalid community string");
                    }
                    case 160: 
                    case 161: 
                    case 162: 
                    case 165: 
                    case 166: 
                    case 168: {
                        String tst = new String(community.getString());
                        String rd = SnmpSession.this.m_peer.getParameters().getReadCommunity();
                        if (tst.equals(rd)) break;
                        throw new SnmpPduEncodingException("Invalid community string");
                    }
                    default: {
                        throw new SnmpPduEncodingException("Invalid PDU Type for session received");
                    }
                }
                if (req != null) {
                    req.m_expired = true;
                    req.m_handler.snmpReceivedPdu(req.m_session, ((SnmpPduRequest)pdu).getCommand(), (SnmpPduRequest)pdu);
                } else if (SnmpSession.this.m_defHandler != null) {
                    SnmpSession.this.m_defHandler.snmpReceivedPdu(null, cmd, pdu);
                }
            }
        }

        public void processSnmpTrap(InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) throws SnmpPduEncodingException {
            throw new SnmpPduEncodingException("Invalid PDU Type for session");
        }

        public void processBadDatagram(DatagramPacket p) {
        }

        public void processException(Exception e) {
        }
    }
}

