/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring.enhancer;

import com.google.gwt.user.client.rpc.RemoteService;
import java.util.Random;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import org.apache.log4j.Logger;
import org.gwtwidgets.server.spring.GWTSpringController;
import org.gwtwidgets.server.spring.ReflectionUtils;
import org.gwtwidgets.server.spring.enhancer.ClassEnhancer;
import org.gwtwidgets.server.spring.enhancer.ConstructionContext;
import org.gwtwidgets.server.spring.enhancer.GWTSpringDelegatingController;

public class JavassistEnhancer
implements ClassEnhancer {
    private Logger logger = Logger.getLogger(JavassistEnhancer.class);

    private void delegateMethod(ConstructionContext context, CtMethod methodOfDelegate) throws Exception {
        boolean doesReturn;
        this.logger.debug((Object)("generating delegate method " + methodOfDelegate));
        this.logger.debug((Object)("Implementing method " + methodOfDelegate));
        CtMethod enhancedMethod = CtNewMethod.copy((CtMethod)methodOfDelegate, (CtClass)context.enhancedClass, null);
        int modifiers = enhancedMethod.getModifiers();
        if ((modifiers & 0x400) != 0) {
            enhancedMethod.setModifiers(modifiers ^= 0x400);
        }
        String token = "__GWTSpringDelegatingController__delegate" + context.delegateCounter;
        StringBuilder body = new StringBuilder();
        body.append(token);
        StringBuilder arguments = new StringBuilder();
        int size = enhancedMethod.getParameterTypes().length;
        String prefix = "";
        for (int i = 0; i < size; ++i) {
            arguments.append(prefix).append("$" + (i + 1));
            prefix = ",";
        }
        body.append(".").append(enhancedMethod.getName()).append("(").append((CharSequence)arguments).append(");");
        boolean bl = doesReturn = !enhancedMethod.getReturnType().equals(CtClass.voidType);
        if (doesReturn) {
            body = new StringBuilder("return ").append((CharSequence)body);
        }
        this.logger.debug((Object)body);
        enhancedMethod.setBody(body.toString());
        context.enhancedClass.addMethod(enhancedMethod);
    }

    private void implementInterface(ConstructionContext context, CtClass interfaceClass) throws Exception {
        CtMethod[] declaredMethods;
        this.logger.debug((Object)("implementing interface " + interfaceClass));
        this.logger.debug((Object)("Implementing interface " + interfaceClass));
        context.enhancedClass.addInterface(interfaceClass);
        for (CtMethod method : declaredMethods = interfaceClass.getDeclaredMethods()) {
            this.delegateMethod(context, method);
        }
        ++context.delegateCounter;
    }

    private void implementDelegateSetter(ConstructionContext context, CtClass delegateClass) throws Exception {
        this.logger.debug((Object)"implementing delegate setter");
        this.logger.debug((Object)"implementing delegate setter");
        String token = "__GWTSpringDelegatingController__delegate" + context.fieldCounter;
        this.logger.debug((Object)("added field " + token));
        context.enhancedClass.addField(new CtField(delegateClass, token, context.enhancedClass));
        StringBuilder body = new StringBuilder("public void " + token + "_setDelegate(");
        body.append(RemoteService.class.getName()).append(" delegate){");
        body.append(token).append(" = (").append(delegateClass.getName()).append(")delegate;}");
        this.logger.debug((Object)body);
        context.enhancedClass.addMethod(CtNewMethod.make((String)body.toString(), (CtClass)context.enhancedClass));
        context.setterBody = context.setterBody + token + " = (" + delegateClass.getName() + ")delegate;\n";
        ++context.fieldCounter;
    }

    private void implementGlobalDelegateSetter(ConstructionContext context) throws Exception {
        CtField[] fields = context.enhancedClass.getDeclaredFields();
        this.logger.debug((Object)"==================== declared fields:");
        for (CtField field : fields) {
            this.logger.debug((Object)field);
        }
        String method = "public void __GWTSpringDelegatingController__setDelegate(" + RemoteService.class.getName() + " delegate){\n";
        method = method + context.setterBody;
        method = method + "};";
        this.logger.debug((Object)method);
        context.enhancedClass.addMethod(CtNewMethod.make((String)method, (CtClass)context.enhancedClass));
    }

    private GWTSpringDelegatingController _createController(RemoteService delegate, boolean unwrapExceptions) throws Exception {
        ConstructionContext context = new ConstructionContext();
        context.classpool = ClassPool.getDefault();
        ClassLoader delegateClassLoader = delegate.getClass().getClassLoader();
        context.classpool.insertClassPath((ClassPath)new LoaderClassPath(delegateClassLoader));
        Random randomGenerator = new Random();
        String className = GWTSpringDelegatingController.class.getName() + Math.abs(randomGenerator.nextLong());
        context.enhancedClass = context.classpool.makeClass(className);
        Class[] delegateClassInterfaces = ReflectionUtils.getImplementedInterfaces(delegate.getClass());
        context.enhancedClass.setSuperclass(context.classpool.get(GWTSpringDelegatingController.class.getName()));
        for (Class delegateInterface : delegateClassInterfaces) {
            CtClass ctDelegateInterface = context.classpool.get(delegateInterface.getName());
            this.implementDelegateSetter(context, ctDelegateInterface);
            this.implementInterface(context, ctDelegateInterface);
        }
        this.implementGlobalDelegateSetter(context);
        Class proxiedClass = context.enhancedClass.toClass();
        GWTSpringDelegatingController controller = (GWTSpringDelegatingController)((Object)proxiedClass.newInstance());
        controller.__GWTSpringDelegatingController__setDelegate(delegate);
        return controller;
    }

    public synchronized GWTSpringController createController(RemoteService delegate, boolean unwrapExceptions) {
        try {
            return this._createController(delegate, unwrapExceptions);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

