/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring.enhancer;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializableException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegatingCallback
implements MethodInterceptor {
    private RemoteService target;
    private Map<Method, Method> methodsOnTarget = new HashMap<Method, Method>();
    private Map<Method, Method> methodsOnExtendedClass = new HashMap<Method, Method>();
    private boolean unwrapExceptions;

    DelegatingCallback(RemoteService target, boolean unwrapExceptions) {
        this.target = target;
        this.unwrapExceptions = unwrapExceptions;
    }

    private synchronized Method getMethodToInvoke(Object target, Object[] arguments, Method prototypeMethod, Map<Method, Method> lookup) {
        Method methodToInvoke = lookup.get(prototypeMethod);
        if (methodToInvoke != null) {
            return methodToInvoke;
        }
        Class<?> targetClass = target.getClass();
        Class<?>[] parameterTypes = prototypeMethod.getParameterTypes();
        String methodName = prototypeMethod.getName();
        try {
            methodToInvoke = targetClass.getMethod(methodName, parameterTypes);
            lookup.put(prototypeMethod, methodToInvoke);
            return methodToInvoke;
        }
        catch (Exception e) {
            try {
                methodToInvoke = targetClass.getDeclaredMethod(methodName, parameterTypes);
                lookup.put(prototypeMethod, methodToInvoke);
                return methodToInvoke;
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        try {
            Method methodToInvoke = this.getMethodToInvoke(this.target, args, method, this.methodsOnTarget);
            if (methodToInvoke != null) {
                return methodToInvoke.invoke((Object)this.target, args);
            }
            methodToInvoke = this.getMethodToInvoke(obj, args, method, this.methodsOnExtendedClass);
            if (methodToInvoke != null) {
                return proxy.invokeSuper(obj, args);
            }
        }
        catch (Throwable e) {
            if (!this.unwrapExceptions) {
                throw e;
            }
            Throwable cause = e;
            while (true) {
                if (cause == null) {
                    throw e;
                }
                if (cause instanceof SerializableException) {
                    throw cause;
                }
                cause = cause.getCause();
            }
        }
        throw new NoSuchMethodException(method.getName() + " on " + obj.getClass());
    }
}

