/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.gwtwidgets.server.spring.GWTSpringController;

public class RequestInjection
implements MethodInterceptor {
    protected String requestSetterName;
    protected String responseSetterName;

    private void setRequestOnTarget(HttpServletRequest request, HttpServletResponse response, Object target) throws Exception {
        Method method;
        if (this.requestSetterName != null) {
            try {
                method = target.getClass().getMethod(this.requestSetterName, ServletRequest.class);
                method.invoke(target, request);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (this.responseSetterName != null) {
            try {
                method = target.getClass().getMethod(this.responseSetterName, ServletResponse.class);
                method.invoke(target, response);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object target = invocation.getThis();
        this.setRequestOnTarget(GWTSpringController.getRequest(), GWTSpringController.getResponse(), target);
        return invocation.proceed();
    }

    public void setRequestSetterName(String setterName) {
        this.requestSetterName = setterName;
    }

    public void setResponseSetterName(String setterName) {
        this.responseSetterName = setterName;
    }
}

