/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import com.google.gwt.user.client.rpc.RemoteService;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gwtwidgets.server.spring.GWTSpringController;
import org.gwtwidgets.server.spring.enhancer.CGLIBEnhancer;
import org.gwtwidgets.server.spring.enhancer.ClassEnhancer;
import org.gwtwidgets.server.spring.enhancer.JavassistEnhancer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWTHandler
extends AbstractUrlHandlerMapping
implements HandlerMapping,
InitializingBean {
    private boolean usingInstrumentation = false;
    private ClassEnhancer enhancer;
    private Logger logger = Logger.getLogger(GWTHandler.class);
    private Map<String, RemoteService> _mapping = new HashMap<String, RemoteService>();
    private boolean unwrappingGWTExceptions = false;

    private GWTSpringController createServiceInstance(RemoteService service) {
        this.logger.debug((Object)("Enhancing " + service.getClass()));
        GWTSpringController controller = this.enhancer.createController(service, this.unwrappingGWTExceptions);
        controller.setServletContext(this.getServletContext());
        return controller;
    }

    public void setUsingInstrumentation(boolean usingInstrumentation) {
        this.usingInstrumentation = usingInstrumentation;
    }

    public void setClassEnhancer(ClassEnhancer enhancer) {
        this.enhancer = enhancer;
    }

    public void setMapping(Map<String, RemoteService> mapping) {
        this._mapping = mapping;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enhancer != null) {
            this.logger.debug((Object)("Employing custom class enhancer " + this.enhancer.getClass()));
        } else if (this.usingInstrumentation) {
            this.logger.debug((Object)"Employing instrumentation (Javassist)");
            this.enhancer = new JavassistEnhancer();
        } else {
            this.logger.debug((Object)"Employing reflection (CGLIB)");
            this.enhancer = new CGLIBEnhancer();
        }
        for (Map.Entry<String, RemoteService> entry : this._mapping.entrySet()) {
            this.registerHandler(entry.getKey(), (Object)this.createServiceInstance(entry.getValue()));
        }
        this._mapping = null;
    }

    public void setUnwrappingGWTExceptions(boolean unwrappingGWTExceptions) {
        this.unwrappingGWTExceptions = unwrappingGWTExceptions;
    }
}

