/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.pooled.interfaces;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.transaction.SystemException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectInputStream;
import org.jboss.invocation.pooled.interfaces.OptimizedObjectOutputStream;
import org.jboss.invocation.pooled.interfaces.PooledMarshalledInvocation;
import org.jboss.invocation.pooled.interfaces.ServerAddress;
import org.jboss.tm.TransactionPropagationContextFactory;

public class PooledInvokerProxy
implements Invoker,
Externalizable {
    private static final long serialVersionUID = -1456509931095566410L;
    protected static TransactionPropagationContextFactory tpcFactory = null;
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    public static long usedPooled = 0L;
    public static int MAX_RETRIES = 10;
    protected static HashMap connectionPools = new HashMap();
    protected ServerAddress address;
    protected LinkedList pool = null;
    protected int maxPoolSize;

    public static void setTPCFactory(TransactionPropagationContextFactory tpcf) {
        tpcFactory = tpcf;
    }

    public PooledInvokerProxy() {
    }

    public PooledInvokerProxy(ServerAddress sa, int maxPoolSize) {
        this.address = sa;
        this.maxPoolSize = maxPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(ServerAddress sa) {
        try {
            LinkedList thepool = (LinkedList)connectionPools.get(sa);
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    ClientSocket socket = (ClientSocket)thepool.removeFirst();
                    try {
                        socket.socket.close();
                        socket.socket = null;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPools() {
        HashMap hashMap = connectionPools;
        synchronized (hashMap) {
            Iterator it = connectionPools.keySet().iterator();
            while (it.hasNext()) {
                ServerAddress sa = (ServerAddress)it.next();
                PooledInvokerProxy.clearPool(sa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        HashMap hashMap = connectionPools;
        synchronized (hashMap) {
            this.pool = (LinkedList)connectionPools.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                connectionPools.put(this.address, this.pool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSocket getConnection() throws Exception {
        Socket socket = null;
        for (int i = 0; i < MAX_RETRIES; ++i) {
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                ClientSocket pooled;
                if (this.pool.size() > 0 && (pooled = this.getPooledConnection()) != null) {
                    ++usedPooled;
                    return pooled;
                }
            }
            try {
                socket = new Socket(this.address.address, this.address.port);
                break;
            }
            catch (Exception ex) {
                if (i + 1 >= MAX_RETRIES) {
                    throw ex;
                }
                Thread.sleep(1L);
                continue;
            }
        }
        socket.setTcpNoDelay(this.address.enableTcpNoDelay);
        return new ClientSocket(socket, this.address.timeout);
    }

    protected ClientSocket getPooledConnection() {
        ClientSocket socket = null;
        while (this.pool.size() > 0) {
            socket = (ClientSocket)this.pool.removeFirst();
            try {
                boolean ACK = true;
                socket.out.writeByte(1);
                socket.out.flush();
                socket.in.readByte();
                return socket;
            }
            catch (Exception ex) {
                try {
                    socket.socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    public Object getTransactionPropagationContext() throws SystemException {
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Exception {
        PooledMarshalledInvocation mi = new PooledMarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        Object response = null;
        long start = System.currentTimeMillis();
        ClientSocket socket = this.getConnection();
        long end = System.currentTimeMillis() - start;
        getSocketTime += end;
        try {
            socket.out.writeObject(mi);
            socket.out.reset();
            socket.out.writeObject(Boolean.TRUE);
            socket.out.flush();
            socket.out.reset();
            end = System.currentTimeMillis() - start;
            writeTime += end;
            start = System.currentTimeMillis();
            response = socket.in.readObject();
            socket.in.readObject();
            end = System.currentTimeMillis() - start;
            readTime += end;
        }
        catch (Exception ex) {
            try {
                socket.socket.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw new ConnectException("Failed to communicate", ex);
        }
        LinkedList ex = this.pool;
        synchronized (ex) {
            if (this.pool.size() < this.maxPoolSize) {
                this.pool.add(socket);
            } else {
                try {
                    socket.socket.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        try {
            if (response instanceof Exception) {
                throw (Exception)response;
            }
            if (response instanceof MarshalledObject) {
                return ((MarshalledObject)response).get();
            }
            return response;
        }
        catch (ServerException ex2) {
            if (ex2.detail instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)ex2.detail;
            }
            if (ex2.detail instanceof TransactionRolledbackException) {
                throw (TransactionRolledbackException)ex2.detail;
            }
            throw ex2;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.address);
        out.writeInt(this.maxPoolSize);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.address = (ServerAddress)in.readObject();
        this.maxPoolSize = in.readInt();
        this.initPool();
    }

    protected static class ClientSocket {
        public ObjectOutputStream out;
        public ObjectInputStream in;
        public Socket socket;
        public int timeout;

        public ClientSocket(Socket socket, int timeout) throws Exception {
            this.socket = socket;
            socket.setSoTimeout(timeout);
            this.timeout = timeout;
            this.out = new OptimizedObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.out.flush();
            this.in = new OptimizedObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }

        protected void finalize() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

