/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.naming;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.lang.Coerce;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.naming.ReferenceIndirector;
import com.mchange.v2.naming.ReferenceMaker;
import com.mchange.v2.ser.IndirectPolicy;
import com.mchange.v2.ser.SerializableUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class JavaBeanReferenceMaker
implements ReferenceMaker {
    private static final MLogger logger = MLog.getLogger(class$com$mchange$v2$naming$JavaBeanReferenceMaker == null ? (class$com$mchange$v2$naming$JavaBeanReferenceMaker = JavaBeanReferenceMaker.class$("com.mchange.v2.naming.JavaBeanReferenceMaker")) : class$com$mchange$v2$naming$JavaBeanReferenceMaker);
    static final String REF_PROPS_KEY = "com.mchange.v2.naming.JavaBeanReferenceMaker.REF_PROPS_KEY";
    static final Object[] EMPTY_ARGS = new Object[0];
    static final byte[] NULL_TOKEN_BYTES = new byte[0];
    String factoryClassName = "com.mchange.v2.naming.JavaBeanObjectFactory";
    String defaultFactoryClassLocation = null;
    Set referenceProperties = new HashSet();
    ReferenceIndirector indirector = new ReferenceIndirector();
    static /* synthetic */ Class class$com$mchange$v2$naming$JavaBeanReferenceMaker;
    static /* synthetic */ Class class$java$lang$String;

    public Hashtable getEnvironmentProperties() {
        return this.indirector.getEnvironmentProperties();
    }

    public void setEnvironmentProperties(Hashtable environmentProperties) {
        this.indirector.setEnvironmentProperties(environmentProperties);
    }

    public void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public String getDefaultFactoryClassLocation() {
        return this.defaultFactoryClassLocation;
    }

    public void setDefaultFactoryClassLocation(String defaultFactoryClassLocation) {
        this.defaultFactoryClassLocation = defaultFactoryClassLocation;
    }

    public void addReferenceProperty(String propName) {
        this.referenceProperties.add(propName);
    }

    public void removeReferenceProperty(String propName) {
        this.referenceProperties.remove(propName);
    }

    public Reference createReference(Object bean) throws NamingException {
        try {
            boolean using_ref_props;
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            ArrayList<BinaryRefAddr> refAddrs = new ArrayList<BinaryRefAddr>();
            String factoryClassLocation = this.defaultFactoryClassLocation;
            boolean bl = using_ref_props = this.referenceProperties.size() > 0;
            if (using_ref_props) {
                refAddrs.add(new BinaryRefAddr(REF_PROPS_KEY, SerializableUtils.toByteArray(this.referenceProperties)));
            }
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                PropertyDescriptor pd = pds[i];
                String propertyName = pd.getName();
                if (using_ref_props && !this.referenceProperties.contains(propertyName)) continue;
                Class<?> propertyType = pd.getPropertyType();
                Method getter = pd.getReadMethod();
                Method setter = pd.getWriteMethod();
                if (getter != null && setter != null) {
                    RefAddr addMe;
                    Object val = getter.invoke(bean, EMPTY_ARGS);
                    if (propertyName.equals("factoryClassLocation")) {
                        if ((class$java$lang$String == null ? JavaBeanReferenceMaker.class$("java.lang.String") : class$java$lang$String) != propertyType) {
                            throw new NamingException(this.getClass().getName() + " requires a factoryClassLocation property to be a string, " + propertyType.getName() + " is not valid.");
                        }
                        factoryClassLocation = (String)val;
                    }
                    if (val == null) {
                        addMe = new BinaryRefAddr(propertyName, NULL_TOKEN_BYTES);
                        refAddrs.add((BinaryRefAddr)addMe);
                        continue;
                    }
                    if (Coerce.canCoerce(propertyType)) {
                        addMe = new StringRefAddr(propertyName, String.valueOf(val));
                        refAddrs.add((BinaryRefAddr)addMe);
                        continue;
                    }
                    addMe = null;
                    PropertyEditor pe = BeansUtils.findPropertyEditor(pd);
                    if (pe != null) {
                        pe.setValue(val);
                        String textValue = pe.getAsText();
                        if (textValue != null) {
                            addMe = new StringRefAddr(propertyName, textValue);
                        }
                    }
                    if (addMe == null) {
                        addMe = new BinaryRefAddr(propertyName, SerializableUtils.toByteArray(val, this.indirector, IndirectPolicy.INDIRECT_ON_EXCEPTION));
                    }
                    refAddrs.add((BinaryRefAddr)addMe);
                    continue;
                }
                if (!logger.isLoggable(MLevel.WARNING)) continue;
                logger.warning(this.getClass().getName() + ": Skipping " + propertyName + " because it is " + (setter == null ? "read-only." : "write-only."));
            }
            Reference out = new Reference(bean.getClass().getName(), this.factoryClassName, factoryClassLocation);
            Iterator ii = refAddrs.iterator();
            while (ii.hasNext()) {
                out.add((RefAddr)ii.next());
            }
            return out;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Exception trying to create Reference.", e);
            }
            throw new NamingException("Could not create reference from bean: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

