/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.StringUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.rrdtool.Interface;
import org.opennms.netmgt.rrd.rrdtool.JniGraphDetails;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JniRrdStrategy
implements RrdStrategy {
    boolean initialized = false;
    boolean graphicsInitialized = false;

    public void closeFile(Object rrd) throws Exception {
        this.checkState("closeFile");
        this.log().debug((Object)("Executing: rrdtool " + rrd.toString()));
        String[] results = Interface.launch((String)rrd.toString());
        if (results[0] != null) {
            throw new Exception(results[0]);
        }
    }

    private void checkState(String methodName) {
        if (!this.initialized) {
            throw new IllegalStateException("the " + methodName + " method cannot be called before initialize");
        }
    }

    public Object createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        this.checkState("createDefinition");
        File f = new File(directory);
        f.mkdirs();
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        if (new File(fileName).exists()) {
            return null;
        }
        StringBuffer createCmd = new StringBuffer("create");
        createCmd.append(' ' + fileName);
        createCmd.append(" --start=" + (System.currentTimeMillis() / 1000L - 10L));
        createCmd.append(" --step=" + step);
        for (RrdDataSource dataSource : dataSources) {
            createCmd.append(" DS:");
            createCmd.append(dataSource.getName()).append(':');
            createCmd.append(dataSource.getType()).append(":");
            createCmd.append(dataSource.getHeartBeat()).append(':');
            createCmd.append(dataSource.getMin()).append(':');
            createCmd.append(dataSource.getMax());
        }
        for (String rra : rraList) {
            createCmd.append(' ');
            createCmd.append(rra);
        }
        return createCmd.toString();
    }

    public void createFile(Object rrdDef) throws Exception {
        this.checkState("createFile");
        if (rrdDef == null) {
            return;
        }
        this.log().debug((Object)("Executing: rrdtool " + rrdDef.toString()));
        Interface.launch((String)((String)rrdDef));
    }

    public Object openFile(String fileName) throws Exception {
        this.checkState("openFile");
        return new StringBuffer("update " + fileName);
    }

    public void updateFile(Object rrd, String owner, String data) throws Exception {
        this.checkState("updateFile");
        StringBuffer cmd = (StringBuffer)rrd;
        cmd.append(' ');
        cmd.append(data);
    }

    public void initialize() throws Exception {
        Interface.init();
        this.initialized = true;
    }

    public void graphicsInitialize() throws Exception {
    }

    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException, RrdException {
        return this.fetchLastValue(rrdFile, ds, "AVERAGE", interval);
    }

    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) {
        String[] fetchStrings;
        this.checkState("fetchLastValue");
        String fetchCmd = "fetch " + rrdFile + " " + consolidationFunction + " -s now-" + interval / 1000 + " -e now-" + interval / 1000;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("fetch: Issuing RRD command: " + fetchCmd));
        }
        if ((fetchStrings = Interface.launch((String)fetchCmd)) == null) {
            this.log().error((Object)"fetch: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            this.log().error((Object)("fetch: RRD database 'fetch' failed, reason: " + fetchStrings[0]));
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            this.log().error((Object)"fetch: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        String[] dsNames = fetchStrings[1].split("\\s");
        int dsIndex = 0;
        for (int i = 0; i < dsNames.length; ++i) {
            if (!dsNames[i].equals(ds)) continue;
            dsIndex = i;
        }
        String dsName = dsNames[dsIndex].trim();
        String[] dsValues = fetchStrings[2].split("\\s");
        Double dsValue = null;
        if (dsValues[dsIndex].trim().equalsIgnoreCase("nan")) {
            dsValue = new Double(Double.NaN);
        } else {
            try {
                dsValue = new Double(dsValues[dsIndex].trim());
            }
            catch (NumberFormatException nfe) {
                this.log().warn((Object)("fetch: Unable to convert fetched value (" + dsValues[dsIndex].trim() + ") to Double for data source " + dsName));
                throw nfe;
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("fetch: fetch successful: " + dsName + "= " + dsValue));
        }
        return dsValue;
    }

    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException, RrdException {
        String fetchCmd;
        String[] fetchStrings;
        this.checkState("fetchLastValue");
        long now = System.currentTimeMillis();
        long latestUpdateTime = (now - now % (long)interval) / 1000L;
        long earliestUpdateTime = (now - now % (long)interval - (long)range) / 1000L;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("fetchInRange: fetching data from " + earliestUpdateTime + " to " + latestUpdateTime));
        }
        if ((fetchStrings = Interface.launch((String)(fetchCmd = "fetch " + rrdFile + " AVERAGE -s " + earliestUpdateTime + " -e " + latestUpdateTime))) == null) {
            this.log().error((Object)"fetchInRange: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            this.log().error((Object)("fetchInRange: RRD database 'fetch' failed, reason: " + fetchStrings[0]));
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            this.log().error((Object)"fetchInRange: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        int numFetched = fetchStrings.length;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("fetchInRange: got " + numFetched + " strings from RRD"));
        }
        String[] dsNames = fetchStrings[1].split("\\s");
        int dsIndex = 0;
        for (int i = 0; i < dsNames.length; ++i) {
            if (!dsNames[i].equals(ds)) continue;
            dsIndex = i;
        }
        String dsName = dsNames[dsIndex].trim();
        for (int i = fetchStrings.length - 2; i > 1; --i) {
            String[] dsValues = fetchStrings[i].split("\\s");
            if (!dsValues[dsIndex].trim().equalsIgnoreCase("nan")) {
                try {
                    Double dsValue = new Double(dsValues[dsIndex].trim());
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("fetchInRange: fetch successful: " + dsName + "= " + dsValue));
                    }
                    return dsValue;
                }
                catch (NumberFormatException nfe) {
                    this.log().warn((Object)("fetchInRange: Unable to convert fetched value (" + dsValues[dsIndex].trim() + ") to Double for data source " + dsName));
                    throw nfe;
                }
            }
            this.log().debug((Object)"fetchInRange: Got a NaN value - continuing back in time");
        }
        return null;
    }

    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        byte[] byteArray = this.createGraphAsByteArray(command, workDir);
        return new ByteArrayInputStream(byteArray);
    }

    private byte[] createGraphAsByteArray(String command, File workDir) throws IOException, RrdException {
        Process process;
        String[] commandArray = StringUtils.createCommandArray((String)command, (char)'@');
        try {
            process = Runtime.getRuntime().exec(commandArray, null, workDir);
        }
        catch (IOException e) {
            IOException newE = new IOException("IOException thrown while executing command '" + command + "' in " + workDir.getAbsolutePath() + ": " + e);
            newE.initCause(e);
            throw newE;
        }
        byte[] byteArray = FileCopyUtils.copyToByteArray((InputStream)process.getInputStream());
        String errors = FileCopyUtils.copyToString((Reader)new InputStreamReader(process.getErrorStream()));
        if (errors.length() > 0) {
            throw new RrdException(errors);
        }
        return byteArray;
    }

    public String getStats() {
        return "";
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public int getGraphLeftOffset() {
        return 65;
    }

    public int getGraphRightOffset() {
        return -30;
    }

    public int getGraphTopOffsetWithText() {
        return -75;
    }

    public String getDefaultFileExtension() {
        return ".rrd";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        ByteArrayInputStream pngStream;
        String[] printLines;
        int height;
        int width;
        File pngFile = File.createTempFile("opennms.rrdtool.", ".png");
        command = command.replaceFirst("graph - ", "graph " + pngFile.getAbsolutePath() + " ");
        try {
            InputStream is = this.createGraph(command, workDir);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            try {
                String[] s = reader.readLine().split("x");
                width = Integer.parseInt(s[0]);
                height = Integer.parseInt(s[1]);
                ArrayList<String> printLinesList = new ArrayList<String>();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    printLinesList.add(line);
                }
                printLines = printLinesList.toArray(new String[printLinesList.size()]);
            }
            finally {
                reader.close();
            }
            byte[] byteArray = FileCopyUtils.copyToByteArray((File)pngFile);
            pngStream = new ByteArrayInputStream(byteArray);
        }
        catch (Exception e) {
            throw new RrdException("Can't execute command " + command, (Throwable)e);
        }
        finally {
            pngFile.delete();
        }
        JniGraphDetails details = new JniGraphDetails(width, height, printLines, pngStream);
        return details;
    }

    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
    }
}

