/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.audit.WorkingMemoryFileLogger;
import org.drools.compiler.PackageBuilder;

public class CorrelationExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(CorrelationExample.class.getResourceAsStream("CorrelationExample.drl")));
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        WorkingMemory workingMemory = ruleBase.newWorkingMemory();
        WorkingMemoryFileLogger logger = new WorkingMemoryFileLogger(workingMemory);
        logger.setFileName("log/correlation");
        InputStream in = CorrelationExample.class.getResourceAsStream("simulation");
        try {
            Simulation simulation = new Simulation();
            System.out.println("Loading Simulation");
            simulation.load(in);
            System.out.println("Executing Simulation");
            simulation.simulate(workingMemory);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        logger.writeToDisk();
    }

    private static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class PossibleCause {
        private Node m_node;
        private Outage m_outage;
        private boolean m_verified;

        public PossibleCause(Node node, Outage outage) {
            this(node, outage, false);
        }

        public PossibleCause(Node node, Outage outage, boolean verified) {
            this.m_node = node;
            this.m_outage = outage;
            this.m_verified = verified;
        }

        public Node getNode() {
            return this.m_node;
        }

        public Outage getOutage() {
            return this.m_outage;
        }

        public boolean isVerified() {
            return this.m_verified;
        }

        public void setVerified(boolean verified) {
            this.m_verified = verified;
        }

        public String toString() {
            return "PossibleCause[ node=" + this.m_node + " , outage=" + this.m_outage + " ]";
        }
    }

    public static class EventBean {
        private String m_uei;
        private Node m_node;

        public EventBean(String uei, Node node) {
            this.m_uei = uei;
            this.m_node = node;
        }

        public String getUei() {
            return this.m_uei;
        }

        public Node getNode() {
            return this.m_node;
        }

        public String toString() {
            return "Event[ uei=" + this.m_uei + " , node=" + this.m_node + " ]";
        }
    }

    public static class Node {
        private Integer m_id;
        private Node m_parent;
        private String m_label;

        public Node(Integer id, String label, Node parent) {
            this.m_id = id;
            this.m_label = label;
            this.m_parent = parent;
        }

        public Integer getId() {
            return this.m_id;
        }

        public Node getParent() {
            return this.m_parent;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String toString() {
            return "Node[ id=" + this.m_id + " , label=" + this.m_label + " ]";
        }
    }

    public static class Outage {
        private EventBean m_problem;
        private EventBean m_resolution;
        private Node m_cause;
        private Node m_node;

        public Outage(Node node, EventBean problem) {
            this.m_node = node;
            this.m_problem = problem;
        }

        public Node getNode() {
            return this.m_node;
        }

        public EventBean getProblem() {
            return this.m_problem;
        }

        public EventBean getResolution() {
            return this.m_resolution;
        }

        public void setResolution(EventBean resolution) {
            this.m_resolution = resolution;
        }

        public Node getCause() {
            return this.m_cause;
        }

        public void setCause(Node cause) {
            this.m_cause = cause;
        }

        public String toString() {
            return "Outage[ problem=" + this.m_problem + " , cause=" + this.m_cause + " , resolution=" + this.m_resolution + " ]";
        }
    }

    public static class Simulation {
        Map<Integer, Node> m_nodes = new HashMap<Integer, Node>();
        List<SimItem> m_eventSequence = new LinkedList<SimItem>();

        public void load(InputStream in) {
            Scanner scanner = new Scanner(in);
            while (scanner.hasNext()) {
                String lineType = scanner.next();
                if ("#".equals(lineType)) {
                    scanner.nextLine();
                    continue;
                }
                if ("node".equals(lineType)) {
                    String nodeLabel = scanner.next();
                    Integer nodeId = scanner.nextInt();
                    assert (this.m_nodes.get(nodeId) == null) : "Already have a node with id " + nodeId;
                    Integer parentId = null;
                    if (scanner.hasNextInt()) {
                        parentId = scanner.nextInt();
                    }
                    assert (parentId == null || this.m_nodes.containsKey(parentId)) : "Reference to parentId " + parentId + " that is not yet defined";
                    Node parent = parentId == null ? null : this.m_nodes.get(parentId);
                    Node node = new Node(nodeId, nodeLabel, parent);
                    this.m_nodes.put(nodeId, node);
                    continue;
                }
                if (!"event".equals(lineType)) continue;
                int delay = scanner.nextInt();
                String uei = scanner.next();
                Integer nodeId = scanner.nextInt();
                assert (this.m_nodes.containsKey(nodeId)) : "Invalid nodeId " + nodeId;
                EventBean e = new EventBean(uei, this.m_nodes.get(nodeId));
                SimItem item = new SimItem(delay, e);
                this.m_eventSequence.add(item);
            }
        }

        public void simulate(WorkingMemory memory) {
            for (SimItem item : this.m_eventSequence) {
                item.simulate(memory);
                System.out.println("Memory Size = " + memory.getObjects().size());
            }
        }

        public static class SimItem {
            int m_delay;
            EventBean m_event;

            public SimItem(int delay, EventBean event) {
                this.m_delay = delay;
                this.m_event = event;
            }

            public void simulate(WorkingMemory memory) {
                CorrelationExample.sleep(this.m_delay);
                System.out.println("Start simulation of " + this);
                memory.assertObject((Object)this.m_event);
                memory.fireAllRules();
                System.out.println("End simulation of " + this);
            }
        }
    }
}

