/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.debug.DebugEventListener;

public class DebugEventSocketProxy
implements DebugEventListener {
    public static final int DEFAULT_DEBUGGER_PORT = 49153;
    protected int port = 49153;
    protected ServerSocket serverSocket;
    protected Socket socket;
    PrintWriter out;
    BufferedReader in;

    public DebugEventSocketProxy() {
        this(49153);
    }

    public DebugEventSocketProxy(int n) {
        this.port = n;
    }

    public void handshake() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.port);
            this.socket = this.serverSocket.accept();
            this.socket.setTcpNoDelay(true);
            OutputStream outputStream = this.socket.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
            InputStream inputStream = this.socket.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            this.in = new BufferedReader(inputStreamReader);
            this.transmit("ANTLR 3.0ea1");
        }
    }

    public void commence() {
    }

    public void terminate() {
        this.transmit("terminate");
        this.out.close();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void ack() {
        try {
            this.in.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void transmit(String string) {
        this.out.println(string);
        this.out.flush();
        this.ack();
    }

    public void enterRule(String string) {
        this.transmit("enterRule " + string);
    }

    public void enterAlt(int n) {
        this.transmit("enterAlt " + n);
    }

    public void exitRule(String string) {
        this.transmit("exitRule " + string);
    }

    public void enterSubRule(int n) {
        this.transmit("enterSubRule " + n);
    }

    public void exitSubRule(int n) {
        this.transmit("exitSubRule " + n);
    }

    public void enterDecision(int n) {
        this.transmit("enterDecision " + n);
    }

    public void exitDecision(int n) {
        this.transmit("exitDecision " + n);
    }

    public void consumeToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeToken " + string);
    }

    public void consumeHiddenToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeHiddenToken " + string);
    }

    public void LT(int n, Token token) {
        if (token != null) {
            this.transmit("LT " + n + " " + this.serializeToken(token));
        }
    }

    public void mark(int n) {
        this.transmit("mark " + n);
    }

    public void rewind(int n) {
        this.transmit("rewind " + n);
    }

    public void location(int n, int n2) {
        this.transmit("location " + n + " " + n2);
    }

    public void recognitionException(RecognitionException recognitionException) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("exception ");
        stringBuffer.append(recognitionException.getClass().getName());
        stringBuffer.append(" ");
        stringBuffer.append(recognitionException.index);
        stringBuffer.append(" ");
        stringBuffer.append(recognitionException.line);
        stringBuffer.append(" ");
        stringBuffer.append(recognitionException.charPositionInLine);
        this.transmit(stringBuffer.toString());
    }

    public void beginResync() {
        this.transmit("beginResync");
    }

    public void endResync() {
        this.transmit("endResync");
    }

    public void semanticPredicate(boolean bl, String string) {
        string = this.escapeNewlines(string);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("semanticPredicate ");
        stringBuffer.append(bl);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        this.transmit(stringBuffer.toString());
    }

    protected String serializeToken(Token token) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(token.getTokenIndex());
        stringBuffer.append(' ');
        stringBuffer.append(token.getType());
        stringBuffer.append(' ');
        stringBuffer.append(token.getChannel());
        stringBuffer.append(' ');
        stringBuffer.append(token.getLine());
        stringBuffer.append(' ');
        stringBuffer.append(token.getCharPositionInLine());
        stringBuffer.append(" \"");
        String string = token.getText();
        if (string == null) {
            string = "";
        }
        string = this.escapeNewlines(string);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected String escapeNewlines(String string) {
        string = string.replaceAll("%", "%25");
        string = string.replaceAll("\n", "%0A");
        string = string.replaceAll("\r", "%0D");
        return string;
    }
}

