/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.properties;

import org.apache.util.DOMUtils;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.ResponseEntity;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ResourceTypeProperty
extends BaseProperty {
    private boolean initialized = false;
    private boolean isCollection;
    public static final String TAG_NAME = "resourcetype";

    public ResourceTypeProperty(ResponseEntity response, Element element) {
        super(response, element);
    }

    public boolean isCollection() {
        this.init();
        return this.isCollection;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        NodeList tmp = this.element.getChildNodes();
        int i = 0;
        while (tmp != null && i < tmp.getLength()) {
            try {
                Element child = (Element)tmp.item(i);
                if ("collection".equals(DOMUtils.getElementLocalName(child)) && "DAV:".equals(DOMUtils.getElementNamespaceURI(child))) {
                    this.isCollection = true;
                    this.initialized = true;
                    return;
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
        this.isCollection = false;
        this.initialized = true;
    }

    public String getPropertyAsString() {
        this.init();
        return this.isCollection ? "COLLECTION" : "";
    }
}

