/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.common.Range;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Definition
implements Serializable {
    private int _retry;
    private boolean _has_retry;
    private int _timeout;
    private boolean _has_timeout;
    private String _readCommunity;
    private String _writeCommunity;
    private String _proxyHost;
    private int _port;
    private boolean _has_port;
    private String _version;
    private int _maxVarsPerPdu = 10;
    private boolean _has_maxVarsPerPdu;
    private int _maxRepetitions = 2;
    private boolean _has_maxRepetitions;
    private int _maxRequestSize = 65535;
    private boolean _has_maxRequestSize;
    private String _securityName;
    private String _authPassphrase;
    private String _authProtocol;
    private String _engineId;
    private String _contextEngineId;
    private String _contextName;
    private String _privacyPassphrase;
    private String _privacyProtocol;
    private String _enterpriseId;
    private List<Range> _rangeList = new ArrayList<Range>();
    private List<String> _specificList = new ArrayList<String>();
    private List<String> _ipMatchList = new ArrayList<String>();

    public void addIpMatch(String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(vIpMatch);
    }

    public void addIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(index, vIpMatch);
    }

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public void deleteMaxRepetitions() {
        this._has_maxRepetitions = false;
    }

    public void deleteMaxRequestSize() {
        this._has_maxRequestSize = false;
    }

    public void deleteMaxVarsPerPdu() {
        this._has_maxVarsPerPdu = false;
    }

    public void deletePort() {
        this._has_port = false;
    }

    public void deleteRetry() {
        this._has_retry = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public Enumeration<String> enumerateIpMatch() {
        return Collections.enumeration(this._ipMatchList);
    }

    public Enumeration<Range> enumerateRange() {
        return Collections.enumeration(this._rangeList);
    }

    public Enumeration<String> enumerateSpecific() {
        return Collections.enumeration(this._specificList);
    }

    public String getAuthPassphrase() {
        return this._authPassphrase;
    }

    public String getAuthProtocol() {
        return this._authProtocol;
    }

    public String getContextEngineId() {
        return this._contextEngineId;
    }

    public String getContextName() {
        return this._contextName;
    }

    public String getEngineId() {
        return this._engineId;
    }

    public String getEnterpriseId() {
        return this._enterpriseId;
    }

    public String getIpMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("getIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        return this._ipMatchList.get(index);
    }

    public String[] getIpMatch() {
        String[] array = new String[]{};
        return this._ipMatchList.toArray(array);
    }

    public List<String> getIpMatchCollection() {
        return this._ipMatchList;
    }

    public int getIpMatchCount() {
        return this._ipMatchList.size();
    }

    public int getMaxRepetitions() {
        return this._maxRepetitions;
    }

    public int getMaxRequestSize() {
        return this._maxRequestSize;
    }

    public int getMaxVarsPerPdu() {
        return this._maxVarsPerPdu;
    }

    public int getPort() {
        return this._port;
    }

    public String getPrivacyPassphrase() {
        return this._privacyPassphrase;
    }

    public String getPrivacyProtocol() {
        return this._privacyProtocol;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("getRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        return this._rangeList.get(index);
    }

    public Range[] getRange() {
        Range[] array = new Range[]{};
        return this._rangeList.toArray(array);
    }

    public List<Range> getRangeCollection() {
        return this._rangeList;
    }

    public int getRangeCount() {
        return this._rangeList.size();
    }

    public String getReadCommunity() {
        return this._readCommunity;
    }

    public int getRetry() {
        return this._retry;
    }

    public String getSecurityName() {
        return this._securityName;
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("getSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        return this._specificList.get(index);
    }

    public String[] getSpecific() {
        String[] array = new String[]{};
        return this._specificList.toArray(array);
    }

    public List<String> getSpecificCollection() {
        return this._specificList;
    }

    public int getSpecificCount() {
        return this._specificList.size();
    }

    public int getTimeout() {
        return this._timeout;
    }

    public String getVersion() {
        return this._version;
    }

    public String getWriteCommunity() {
        return this._writeCommunity;
    }

    public boolean hasMaxRepetitions() {
        return this._has_maxRepetitions;
    }

    public boolean hasMaxRequestSize() {
        return this._has_maxRequestSize;
    }

    public boolean hasMaxVarsPerPdu() {
        return this._has_maxVarsPerPdu;
    }

    public boolean hasPort() {
        return this._has_port;
    }

    public boolean hasRetry() {
        return this._has_retry;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<String> iterateIpMatch() {
        return this._ipMatchList.iterator();
    }

    public Iterator<Range> iterateRange() {
        return this._rangeList.iterator();
    }

    public Iterator<String> iterateSpecific() {
        return this._specificList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllIpMatch() {
        this._ipMatchList.clear();
    }

    public void removeAllRange() {
        this._rangeList.clear();
    }

    public void removeAllSpecific() {
        this._specificList.clear();
    }

    public boolean removeIpMatch(String vIpMatch) {
        boolean removed = this._ipMatchList.remove(vIpMatch);
        return removed;
    }

    public String removeIpMatchAt(int index) {
        String obj = this._ipMatchList.remove(index);
        return obj;
    }

    public boolean removeRange(Range vRange) {
        boolean removed = this._rangeList.remove(vRange);
        return removed;
    }

    public Range removeRangeAt(int index) {
        Range obj = this._rangeList.remove(index);
        return obj;
    }

    public boolean removeSpecific(String vSpecific) {
        boolean removed = this._specificList.remove(vSpecific);
        return removed;
    }

    public String removeSpecificAt(int index) {
        String obj = this._specificList.remove(index);
        return obj;
    }

    public void setAuthPassphrase(String authPassphrase) {
        this._authPassphrase = authPassphrase;
    }

    public void setAuthProtocol(String authProtocol) {
        this._authProtocol = authProtocol;
    }

    public void setContextEngineId(String contextEngineId) {
        this._contextEngineId = contextEngineId;
    }

    public void setContextName(String contextName) {
        this._contextName = contextName;
    }

    public void setEngineId(String engineId) {
        this._engineId = engineId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this._enterpriseId = enterpriseId;
    }

    public void setIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException("setIpMatch: Index value '" + index + "' not in range [0.." + (this._ipMatchList.size() - 1) + "]");
        }
        this._ipMatchList.set(index, vIpMatch);
    }

    public void setIpMatch(String[] vIpMatchArray) {
        this._ipMatchList.clear();
        for (int i = 0; i < vIpMatchArray.length; ++i) {
            this._ipMatchList.add(vIpMatchArray[i]);
        }
    }

    public void setIpMatch(List<String> vIpMatchList) {
        this._ipMatchList.clear();
        this._ipMatchList.addAll(vIpMatchList);
    }

    public void setIpMatchCollection(List<String> ipMatchList) {
        this._ipMatchList = ipMatchList;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this._maxRepetitions = maxRepetitions;
        this._has_maxRepetitions = true;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this._maxRequestSize = maxRequestSize;
        this._has_maxRequestSize = true;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this._maxVarsPerPdu = maxVarsPerPdu;
        this._has_maxVarsPerPdu = true;
    }

    public void setPort(int port) {
        this._port = port;
        this._has_port = true;
    }

    public void setPrivacyPassphrase(String privacyPassphrase) {
        this._privacyPassphrase = privacyPassphrase;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this._privacyProtocol = privacyProtocol;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._rangeList.size()) {
            throw new IndexOutOfBoundsException("setRange: Index value '" + index + "' not in range [0.." + (this._rangeList.size() - 1) + "]");
        }
        this._rangeList.set(index, vRange);
    }

    public void setRange(Range[] vRangeArray) {
        this._rangeList.clear();
        for (int i = 0; i < vRangeArray.length; ++i) {
            this._rangeList.add(vRangeArray[i]);
        }
    }

    public void setRange(List<Range> vRangeList) {
        this._rangeList.clear();
        this._rangeList.addAll(vRangeList);
    }

    public void setRangeCollection(List<Range> rangeList) {
        this._rangeList = rangeList;
    }

    public void setReadCommunity(String readCommunity) {
        this._readCommunity = readCommunity;
    }

    public void setRetry(int retry) {
        this._retry = retry;
        this._has_retry = true;
    }

    public void setSecurityName(String securityName) {
        this._securityName = securityName;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("setSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] vSpecificArray) {
        this._specificList.clear();
        for (int i = 0; i < vSpecificArray.length; ++i) {
            this._specificList.add(vSpecificArray[i]);
        }
    }

    public void setSpecific(List<String> vSpecificList) {
        this._specificList.clear();
        this._specificList.addAll(vSpecificList);
    }

    public void setSpecificCollection(List<String> specificList) {
        this._specificList = specificList;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setWriteCommunity(String writeCommunity) {
        this._writeCommunity = writeCommunity;
    }

    public static Definition unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Definition)Unmarshaller.unmarshal(Definition.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

