/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.discovery;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryConfiguration
implements Serializable {
    private int _threads;
    private boolean _has_threads;
    private int _packetsPerSecond;
    private boolean _has_packetsPerSecond;
    private long _initialSleepTime;
    private boolean _has_initialSleepTime;
    private long _restartSleepTime;
    private boolean _has_restartSleepTime;
    private int _retries;
    private boolean _has_retries;
    private long _timeout;
    private boolean _has_timeout;
    private List<Specific> _specificList = new ArrayList<Specific>();
    private List<IncludeRange> _includeRangeList = new ArrayList<IncludeRange>();
    private List<ExcludeRange> _excludeRangeList = new ArrayList<ExcludeRange>();
    private List<IncludeUrl> _includeUrlList = new ArrayList<IncludeUrl>();

    public void addExcludeRange(ExcludeRange vExcludeRange) throws IndexOutOfBoundsException {
        this._excludeRangeList.add(vExcludeRange);
    }

    public void addExcludeRange(int index, ExcludeRange vExcludeRange) throws IndexOutOfBoundsException {
        this._excludeRangeList.add(index, vExcludeRange);
    }

    public void addIncludeRange(IncludeRange vIncludeRange) throws IndexOutOfBoundsException {
        this._includeRangeList.add(vIncludeRange);
    }

    public void addIncludeRange(int index, IncludeRange vIncludeRange) throws IndexOutOfBoundsException {
        this._includeRangeList.add(index, vIncludeRange);
    }

    public void addIncludeUrl(IncludeUrl vIncludeUrl) throws IndexOutOfBoundsException {
        this._includeUrlList.add(vIncludeUrl);
    }

    public void addIncludeUrl(int index, IncludeUrl vIncludeUrl) throws IndexOutOfBoundsException {
        this._includeUrlList.add(index, vIncludeUrl);
    }

    public void addSpecific(Specific vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, Specific vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public void deleteInitialSleepTime() {
        this._has_initialSleepTime = false;
    }

    public void deletePacketsPerSecond() {
        this._has_packetsPerSecond = false;
    }

    public void deleteRestartSleepTime() {
        this._has_restartSleepTime = false;
    }

    public void deleteRetries() {
        this._has_retries = false;
    }

    public void deleteThreads() {
        this._has_threads = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public Enumeration<ExcludeRange> enumerateExcludeRange() {
        return Collections.enumeration(this._excludeRangeList);
    }

    public Enumeration<IncludeRange> enumerateIncludeRange() {
        return Collections.enumeration(this._includeRangeList);
    }

    public Enumeration<IncludeUrl> enumerateIncludeUrl() {
        return Collections.enumeration(this._includeUrlList);
    }

    public Enumeration<Specific> enumerateSpecific() {
        return Collections.enumeration(this._specificList);
    }

    public ExcludeRange getExcludeRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._excludeRangeList.size()) {
            throw new IndexOutOfBoundsException("getExcludeRange: Index value '" + index + "' not in range [0.." + (this._excludeRangeList.size() - 1) + "]");
        }
        return this._excludeRangeList.get(index);
    }

    public ExcludeRange[] getExcludeRange() {
        ExcludeRange[] array = new ExcludeRange[]{};
        return this._excludeRangeList.toArray(array);
    }

    public List<ExcludeRange> getExcludeRangeCollection() {
        return this._excludeRangeList;
    }

    public int getExcludeRangeCount() {
        return this._excludeRangeList.size();
    }

    public IncludeRange getIncludeRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._includeRangeList.size()) {
            throw new IndexOutOfBoundsException("getIncludeRange: Index value '" + index + "' not in range [0.." + (this._includeRangeList.size() - 1) + "]");
        }
        return this._includeRangeList.get(index);
    }

    public IncludeRange[] getIncludeRange() {
        IncludeRange[] array = new IncludeRange[]{};
        return this._includeRangeList.toArray(array);
    }

    public List<IncludeRange> getIncludeRangeCollection() {
        return this._includeRangeList;
    }

    public int getIncludeRangeCount() {
        return this._includeRangeList.size();
    }

    public IncludeUrl getIncludeUrl(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._includeUrlList.size()) {
            throw new IndexOutOfBoundsException("getIncludeUrl: Index value '" + index + "' not in range [0.." + (this._includeUrlList.size() - 1) + "]");
        }
        return this._includeUrlList.get(index);
    }

    public IncludeUrl[] getIncludeUrl() {
        IncludeUrl[] array = new IncludeUrl[]{};
        return this._includeUrlList.toArray(array);
    }

    public List<IncludeUrl> getIncludeUrlCollection() {
        return this._includeUrlList;
    }

    public int getIncludeUrlCount() {
        return this._includeUrlList.size();
    }

    public long getInitialSleepTime() {
        return this._initialSleepTime;
    }

    public int getPacketsPerSecond() {
        return this._packetsPerSecond;
    }

    public long getRestartSleepTime() {
        return this._restartSleepTime;
    }

    public int getRetries() {
        return this._retries;
    }

    public Specific getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("getSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        return this._specificList.get(index);
    }

    public Specific[] getSpecific() {
        Specific[] array = new Specific[]{};
        return this._specificList.toArray(array);
    }

    public List<Specific> getSpecificCollection() {
        return this._specificList;
    }

    public int getSpecificCount() {
        return this._specificList.size();
    }

    public int getThreads() {
        return this._threads;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean hasInitialSleepTime() {
        return this._has_initialSleepTime;
    }

    public boolean hasPacketsPerSecond() {
        return this._has_packetsPerSecond;
    }

    public boolean hasRestartSleepTime() {
        return this._has_restartSleepTime;
    }

    public boolean hasRetries() {
        return this._has_retries;
    }

    public boolean hasThreads() {
        return this._has_threads;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<ExcludeRange> iterateExcludeRange() {
        return this._excludeRangeList.iterator();
    }

    public Iterator<IncludeRange> iterateIncludeRange() {
        return this._includeRangeList.iterator();
    }

    public Iterator<IncludeUrl> iterateIncludeUrl() {
        return this._includeUrlList.iterator();
    }

    public Iterator<Specific> iterateSpecific() {
        return this._specificList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllExcludeRange() {
        this._excludeRangeList.clear();
    }

    public void removeAllIncludeRange() {
        this._includeRangeList.clear();
    }

    public void removeAllIncludeUrl() {
        this._includeUrlList.clear();
    }

    public void removeAllSpecific() {
        this._specificList.clear();
    }

    public boolean removeExcludeRange(ExcludeRange vExcludeRange) {
        boolean removed = this._excludeRangeList.remove(vExcludeRange);
        return removed;
    }

    public ExcludeRange removeExcludeRangeAt(int index) {
        ExcludeRange obj = this._excludeRangeList.remove(index);
        return obj;
    }

    public boolean removeIncludeRange(IncludeRange vIncludeRange) {
        boolean removed = this._includeRangeList.remove(vIncludeRange);
        return removed;
    }

    public IncludeRange removeIncludeRangeAt(int index) {
        IncludeRange obj = this._includeRangeList.remove(index);
        return obj;
    }

    public boolean removeIncludeUrl(IncludeUrl vIncludeUrl) {
        boolean removed = this._includeUrlList.remove(vIncludeUrl);
        return removed;
    }

    public IncludeUrl removeIncludeUrlAt(int index) {
        IncludeUrl obj = this._includeUrlList.remove(index);
        return obj;
    }

    public boolean removeSpecific(Specific vSpecific) {
        boolean removed = this._specificList.remove(vSpecific);
        return removed;
    }

    public Specific removeSpecificAt(int index) {
        Specific obj = this._specificList.remove(index);
        return obj;
    }

    public void setExcludeRange(int index, ExcludeRange vExcludeRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._excludeRangeList.size()) {
            throw new IndexOutOfBoundsException("setExcludeRange: Index value '" + index + "' not in range [0.." + (this._excludeRangeList.size() - 1) + "]");
        }
        this._excludeRangeList.set(index, vExcludeRange);
    }

    public void setExcludeRange(ExcludeRange[] vExcludeRangeArray) {
        this._excludeRangeList.clear();
        for (int i = 0; i < vExcludeRangeArray.length; ++i) {
            this._excludeRangeList.add(vExcludeRangeArray[i]);
        }
    }

    public void setExcludeRange(List<ExcludeRange> vExcludeRangeList) {
        this._excludeRangeList.clear();
        this._excludeRangeList.addAll(vExcludeRangeList);
    }

    public void setExcludeRangeCollection(List<ExcludeRange> excludeRangeList) {
        this._excludeRangeList = excludeRangeList;
    }

    public void setIncludeRange(int index, IncludeRange vIncludeRange) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._includeRangeList.size()) {
            throw new IndexOutOfBoundsException("setIncludeRange: Index value '" + index + "' not in range [0.." + (this._includeRangeList.size() - 1) + "]");
        }
        this._includeRangeList.set(index, vIncludeRange);
    }

    public void setIncludeRange(IncludeRange[] vIncludeRangeArray) {
        this._includeRangeList.clear();
        for (int i = 0; i < vIncludeRangeArray.length; ++i) {
            this._includeRangeList.add(vIncludeRangeArray[i]);
        }
    }

    public void setIncludeRange(List<IncludeRange> vIncludeRangeList) {
        this._includeRangeList.clear();
        this._includeRangeList.addAll(vIncludeRangeList);
    }

    public void setIncludeRangeCollection(List<IncludeRange> includeRangeList) {
        this._includeRangeList = includeRangeList;
    }

    public void setIncludeUrl(int index, IncludeUrl vIncludeUrl) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._includeUrlList.size()) {
            throw new IndexOutOfBoundsException("setIncludeUrl: Index value '" + index + "' not in range [0.." + (this._includeUrlList.size() - 1) + "]");
        }
        this._includeUrlList.set(index, vIncludeUrl);
    }

    public void setIncludeUrl(IncludeUrl[] vIncludeUrlArray) {
        this._includeUrlList.clear();
        for (int i = 0; i < vIncludeUrlArray.length; ++i) {
            this._includeUrlList.add(vIncludeUrlArray[i]);
        }
    }

    public void setIncludeUrl(List<IncludeUrl> vIncludeUrlList) {
        this._includeUrlList.clear();
        this._includeUrlList.addAll(vIncludeUrlList);
    }

    public void setIncludeUrlCollection(List<IncludeUrl> includeUrlList) {
        this._includeUrlList = includeUrlList;
    }

    public void setInitialSleepTime(long initialSleepTime) {
        this._initialSleepTime = initialSleepTime;
        this._has_initialSleepTime = true;
    }

    public void setPacketsPerSecond(int packetsPerSecond) {
        this._packetsPerSecond = packetsPerSecond;
        this._has_packetsPerSecond = true;
    }

    public void setRestartSleepTime(long restartSleepTime) {
        this._restartSleepTime = restartSleepTime;
        this._has_restartSleepTime = true;
    }

    public void setRetries(int retries) {
        this._retries = retries;
        this._has_retries = true;
    }

    public void setSpecific(int index, Specific vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._specificList.size()) {
            throw new IndexOutOfBoundsException("setSpecific: Index value '" + index + "' not in range [0.." + (this._specificList.size() - 1) + "]");
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(Specific[] vSpecificArray) {
        this._specificList.clear();
        for (int i = 0; i < vSpecificArray.length; ++i) {
            this._specificList.add(vSpecificArray[i]);
        }
    }

    public void setSpecific(List<Specific> vSpecificList) {
        this._specificList.clear();
        this._specificList.addAll(vSpecificList);
    }

    public void setSpecificCollection(List<Specific> specificList) {
        this._specificList = specificList;
    }

    public void setThreads(int threads) {
        this._threads = threads;
        this._has_threads = true;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public static DiscoveryConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DiscoveryConfiguration)Unmarshaller.unmarshal(DiscoveryConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

