/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.specification;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.modelimport.Category;
import org.opennms.netmgt.config.modelimport.Interface;
import org.opennms.netmgt.config.modelimport.ModelImport;
import org.opennms.netmgt.config.modelimport.MonitoredService;
import org.opennms.netmgt.config.modelimport.Node;
import org.opennms.netmgt.importer.ModelImportException;
import org.opennms.netmgt.importer.specification.ImportVisitor;
import org.springframework.core.io.Resource;

public class SpecFile {
    private ModelImport m_mi;

    public void loadResource(Resource resource) throws ModelImportException, IOException {
        InputStreamReader reader = new InputStreamReader(resource.getInputStream());
        this.unmarshall(reader);
        this.closeQuietly(reader);
    }

    private void closeQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void unmarshall(Reader rdr) throws ModelImportException {
        try {
            this.m_mi = (ModelImport)Unmarshaller.unmarshal(ModelImport.class, (Reader)rdr);
        }
        catch (MarshalException e) {
            throw new ModelImportException("Exception while marshalling import: " + (Object)((Object)e), e);
        }
        catch (ValidationException e) {
            throw new ModelImportException("Exception while validating import " + (Object)((Object)e));
        }
    }

    public void visitImport(ImportVisitor visitor) {
        this.doVisitImport(visitor);
    }

    private void doVisitImport(ImportVisitor visitor) {
        visitor.visitModelImport(this.m_mi);
        Enumeration nodes = this.m_mi.enumerateNode();
        while (nodes.hasMoreElements()) {
            Node node = (Node)nodes.nextElement();
            this.visitNode(visitor, node);
        }
        visitor.completeModelImport(this.m_mi);
    }

    private void visitNode(ImportVisitor visitor, Node node) {
        this.doVisitNode(visitor, node);
    }

    private void doVisitNode(ImportVisitor visitor, Node node) {
        visitor.visitNode(node);
        Enumeration categories = node.enumerateCategory();
        while (categories.hasMoreElements()) {
            Category category = (Category)categories.nextElement();
            this.visitCategory(visitor, category);
        }
        Enumeration ifaces = node.enumerateInterface();
        while (ifaces.hasMoreElements()) {
            Interface iface = (Interface)ifaces.nextElement();
            this.visitInterface(visitor, iface);
        }
        visitor.completeNode(node);
    }

    private void visitCategory(ImportVisitor visitor, Category category) {
        this.doVisitCategory(visitor, category);
    }

    private void doVisitCategory(ImportVisitor visitor, Category category) {
        visitor.visitCategory(category);
        visitor.completeCategory(category);
    }

    private void visitInterface(ImportVisitor visitor, Interface iface) {
        this.doVisitInterface(visitor, iface);
    }

    private void doVisitInterface(ImportVisitor visitor, Interface iface) {
        visitor.visitInterface(iface);
        Enumeration svcs = iface.enumerateMonitoredService();
        while (svcs.hasMoreElements()) {
            MonitoredService svc = (MonitoredService)svcs.nextElement();
            this.visitMonitoredService(visitor, svc);
        }
        visitor.completeInterface(iface);
    }

    private void visitMonitoredService(ImportVisitor visitor, MonitoredService svc) {
        this.doVisitMonitoredService(visitor, svc);
    }

    private void doVisitMonitoredService(ImportVisitor visitor, MonitoredService svc) {
        visitor.visitMonitoredService(svc);
        visitor.completeMonitoredService(svc);
    }

    public String getForeignSource() {
        return this.m_mi.getForeignSource();
    }

    public void setForeignSource(String foreignSource) {
        this.m_mi.setForeignSource(foreignSource);
    }
}

