/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.importer.operations;

import java.net.InetAddress;
import java.util.List;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddEventVisitor
extends AbstractEntityVisitor {
    private final List<Event> m_events;

    AddEventVisitor(List<Event> events) {
        this.m_events = events;
    }

    public void visitNode(OnmsNode node) {
        this.m_events.add(EventUtils.createNodeAddedEvent((int)node.getId(), (String)node.getLabel(), (String)node.getLabelSource()));
    }

    public void visitIpInterface(OnmsIpInterface iface) {
        this.m_events.add(EventUtils.createNodeGainedInterfaceEvent((String)"ModelImporter", (int)iface.getNode().getId(), (InetAddress)iface.getInetAddress()));
    }

    public void visitMonitoredService(OnmsMonitoredService monSvc) {
        OnmsIpInterface iface = monSvc.getIpInterface();
        OnmsNode node = iface.getNode();
        this.m_events.add(EventUtils.createNodeGainedServiceEvent((String)"ModelImporter", (int)monSvc.getNodeId(), (InetAddress)iface.getInetAddress(), (String)monSvc.getServiceType().getName(), (String)node.getLabel(), (String)node.getLabelSource(), (String)node.getSysName(), (String)node.getSysDescription()));
    }
}

