/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jradiusclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;

public class RadiusPacket {
    public static final int MIN_PACKET_LENGTH = 20;
    public static final int MAX_PACKET_LENGTH = 4096;
    public static final short RADIUS_HEADER_LENGTH = 20;
    public static final String EMPTYSTRING = "";
    public static final int ACCESS_REQUEST = 1;
    public static final int ACCESS_ACCEPT = 2;
    public static final int ACCESS_REJECT = 3;
    public static final int ACCOUNTING_REQUEST = 4;
    public static final int ACCOUNTING_RESPONSE = 5;
    public static final int ACCOUNTING_STATUS = 6;
    public static final int PASSWORD_REQUEST = 7;
    public static final int PASSWORD_ACCEPT = 8;
    public static final int PASSWORD_REJECT = 9;
    public static final int ACCOUNTING_MESSAGE = 10;
    public static final int ACCESS_CHALLENGE = 11;
    public static final int STATUS_SERVER = 12;
    public static final int STATUS_CLIENT = 13;
    public static final int RESERVED = 255;
    private static Object nextPacketIdLock = new Object();
    private static byte nextPacketId = 0;
    private int packetType = 0;
    private byte packetIdentifier = 0;
    private Map attributes;

    public RadiusPacket(int n) throws InvalidParameterException {
        this(n, RadiusPacket.getAndIncrementPacketIdentifier(), new ArrayList());
    }

    public RadiusPacket(int n, byte by) throws InvalidParameterException {
        this(n, by, new ArrayList());
    }

    public RadiusPacket(int n, List list) throws InvalidParameterException {
        this(n, RadiusPacket.getAndIncrementPacketIdentifier(), list);
    }

    public RadiusPacket(int n, byte by, List list) throws InvalidParameterException {
        if (n < 1 || n > 256) {
            throw new InvalidParameterException("Type was out of bounds");
        }
        if (null == list) {
            throw new InvalidParameterException("Attribute List was null");
        }
        this.packetType = n;
        this.packetIdentifier = by;
        this.attributes = new HashMap();
        this.setAttributes(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
        if (null == radiusAttribute) {
            throw new InvalidParameterException("radiusAttribute was null");
        }
        this.validateAttribute(radiusAttribute);
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.put(new Integer(radiusAttribute.getType()), radiusAttribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(List list) throws InvalidParameterException {
        if (null == list) {
            throw new InvalidParameterException("Attribute List was null");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RadiusAttribute radiusAttribute;
            try {
                radiusAttribute = (RadiusAttribute)iterator.next();
                this.validateAttribute(radiusAttribute);
            }
            catch (ClassCastException classCastException) {
                throw new InvalidParameterException("Attribute List contained an entry that was not a net.sourceforge.jradiusclient.RadiusAttribute");
            }
            Map map = this.attributes;
            synchronized (map) {
                this.attributes.put(new Integer(radiusAttribute.getType()), radiusAttribute);
            }
        }
    }

    protected void validateAttribute(RadiusAttribute radiusAttribute) throws InvalidParameterException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadiusAttribute getAttribute(int n) throws InvalidParameterException, RadiusException {
        if (n < 0 || n > 256) {
            throw new InvalidParameterException("attributeType is out of bounds");
        }
        RadiusAttribute radiusAttribute = null;
        Map map = this.attributes;
        synchronized (map) {
            radiusAttribute = (RadiusAttribute)this.attributes.get(new Integer(n));
        }
        if (null == radiusAttribute) {
            throw new RadiusException("No attribute found for type " + n);
        }
        return radiusAttribute;
    }

    public Collection getAttributes() {
        return this.attributes.values();
    }

    public byte getPacketType() {
        return (byte)this.packetType;
    }

    public byte getPacketIdentifier() {
        return this.packetIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getAttributeBytes() throws RadiusException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Map map = this.attributes;
        synchronized (map) {
            Iterator iterator = this.attributes.values().iterator();
            while (iterator.hasNext()) {
                try {
                    byteArrayOutputStream.write(((RadiusAttribute)iterator.next()).getBytes());
                }
                catch (IOException iOException) {
                    throw new RadiusException("Error writing bytes to ByteArrayOutputStream!!!");
                }
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte getAndIncrementPacketIdentifier() {
        Object object = nextPacketIdLock;
        synchronized (object) {
            byte by = nextPacketId;
            nextPacketId = (byte)(by + 1);
            byte by2 = by;
            return by2;
        }
    }
}

