/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.TupleExpression;

public class ConstructorCallExpression
extends Expression {
    private Expression arguments;

    public ConstructorCallExpression(ClassNode type, Expression arguments) {
        super.setType(type);
        if (!(arguments instanceof TupleExpression)) {
            TupleExpression tuple = new TupleExpression();
            tuple.addExpression(arguments);
            this.arguments = tuple;
        } else {
            this.arguments = arguments;
        }
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitConstructorCallExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        Expression args = transformer.transform(this.arguments);
        ConstructorCallExpression ret = new ConstructorCallExpression(this.getType(), args);
        ret.setSourcePosition(this);
        return ret;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    public String getText() {
        return "new " + this.getType() + "(" + this.arguments.getText() + ")";
    }

    public String toString() {
        return super.toString() + "[type: " + this.getType() + " arguments: " + this.arguments + "]";
    }

    public boolean isSuperCall() {
        return this.getType() == ClassNode.SUPER;
    }

    public boolean isSpecialCall() {
        return this.isThisCall() || this.isSuperCall();
    }

    public boolean isThisCall() {
        return this.getType() == ClassNode.THIS;
    }
}

