/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.File;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.daemon.SpringServiceDaemon;
import org.opennms.serviceregistration.ServiceRegistrationFactory;
import org.opennms.serviceregistration.ServiceRegistrationStrategy;

public class JettyServer
extends AbstractServiceDaemon
implements SpringServiceDaemon {
    int m_port = 8080;
    private Server m_server;
    private Hashtable<String, ServiceRegistrationStrategy> services = new Hashtable();

    protected JettyServer() {
        super("OpenNMS.JettyServer");
    }

    protected void onInit() {
        Properties p = System.getProperties();
        File homeDir = new File(p.getProperty("opennms.home"));
        File webappsDir = new File(homeDir, "jetty-webapps");
        this.m_server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        Integer port = Integer.getInteger("org.opennms.netmgt.jetty.port", this.m_port);
        connector.setPort(port.intValue());
        String host = System.getProperty("org.opennms.netmgt.jetty.host");
        if (host != null) {
            connector.setHost(host);
        }
        this.m_server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        if (webappsDir.exists()) {
            for (File file : webappsDir.listFiles()) {
                if (!file.isDirectory()) continue;
                String contextPath = "/" + file.getName();
                this.addContext(handlers, file, contextPath);
                this.registerService(port, contextPath);
            }
        }
        this.m_server.setHandler((Handler)handlers);
        this.m_server.setStopAtShutdown(true);
    }

    protected void addContext(HandlerCollection handlers, File name, String contextPath) {
        this.log().warn((Object)("adding context: " + contextPath + " -> " + name.getAbsolutePath()));
        WebAppContext wac = new WebAppContext();
        wac.setWar(name.getAbsolutePath());
        wac.setContextPath(contextPath);
        handlers.addHandler((Handler)wac);
    }

    protected void registerService(Integer port, String contextPath) {
        String contextName = contextPath.replace("/", "");
        try {
            ServiceRegistrationStrategy srs = ServiceRegistrationFactory.getStrategy();
            String host = InetAddress.getLocalHost().getHostName().replace(".local", "").replace(".", "-");
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("path", contextPath);
            srs.initialize("HTTP", contextName + "-" + host, port.intValue(), properties);
            this.services.put(contextName, srs);
        }
        catch (Exception e) {
            this.log().warn((Object)("unable to get a DNS-SD object for context '" + contextPath + "'"), (Throwable)e);
        }
    }

    protected void onStart() {
        try {
            this.m_server.start();
        }
        catch (Exception e) {
            this.log().error((Object)"Error starting Jetty Server", (Throwable)e);
        }
        for (String key : this.services.keySet()) {
            ServiceRegistrationStrategy srs = this.services.get(key);
            if (srs == null) continue;
            try {
                srs.register();
            }
            catch (Exception e) {
                this.log().warn((Object)("unable to register a DNS-SD object for context '" + key + "'"), (Throwable)e);
            }
        }
    }

    protected void onStop() {
        for (String key : this.services.keySet()) {
            ServiceRegistrationStrategy srs = this.services.get(key);
            if (srs == null) continue;
            try {
                srs.unregister();
            }
            catch (Exception e) {
                this.log().warn((Object)("unable to unregister a DNS-SD object for context '" + key + "'"), (Throwable)e);
            }
        }
        try {
            this.m_server.stop();
        }
        catch (Exception e) {
            this.log().error((Object)"Error stopping Jetty Server", (Throwable)e);
        }
    }
}

