/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.serviceregistration.strategies;

import com.apple.dnssd.DNSSD;
import com.apple.dnssd.DNSSDRegistration;
import com.apple.dnssd.DNSSDService;
import com.apple.dnssd.RegisterListener;
import com.apple.dnssd.TXTRecord;
import java.util.Enumeration;
import java.util.Hashtable;
import org.opennms.serviceregistration.ServiceRegistrationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppleStrategy
implements ServiceRegistrationStrategy,
RegisterListener {
    private boolean registered = false;
    private DNSSDRegistration registration;
    private String serviceType;
    private String serviceName;
    private int port;
    private Hashtable<String, String> properties;

    @Override
    public void initialize(String serviceType, String serviceName, int port) throws Exception {
        this.initialize(serviceType, serviceName, port, null);
    }

    @Override
    public void initialize(String serviceType, String serviceName, int port, Hashtable<String, String> properties) throws Exception {
        if (this.registered) {
            throw new Exception("You have already registered a service with this object!");
        }
        this.serviceType = "_" + serviceType.toLowerCase() + "._tcp";
        this.serviceName = serviceName;
        this.port = port;
        this.properties = properties;
    }

    @Override
    public void register() throws Exception {
        if (!this.registered) {
            TXTRecord txt = new TXTRecord();
            if (this.properties != null) {
                Enumeration<String> e = this.properties.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    String value = this.properties.get(key);
                    txt.set(key, value);
                }
            }
            DNSSD.register((int)0, (int)0, (String)this.serviceName, (String)this.serviceType, null, null, (int)this.port, (TXTRecord)txt, (RegisterListener)this);
        } else {
            System.err.println("WARNING: register() called but the service has already been registered!");
        }
    }

    @Override
    public void unregister() throws Exception {
        if (this.registered) {
            if (this.registration != null) {
                this.registration.stop();
                this.registration = null;
            } else {
                System.err.println("WARNING: unregister() has been called, but registration previously failed.");
            }
        } else {
            System.err.println("WARNING: unregister() called but no service has been registered.");
        }
    }

    public void serviceRegistered(DNSSDRegistration registration, int flags, String serviceName, String regType, String domain) {
        this.registration = registration;
        this.registered = true;
    }

    public void operationFailed(DNSSDService service, int errorCode) {
        this.registered = false;
        System.err.println("registration failed for service '" + service + "' with error code '" + errorCode + "'");
    }
}

