/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.ip;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class IPv4Address
implements Serializable {
    static final long serialVersionUID = 1946711645921732057L;
    private byte[] m_addr;

    private byte[] dup(byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i];
            }
        }
        return byArray2;
    }

    private static int byteToInt(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public static String addressToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n >> 24 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(n >> 16 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(n >> 8 & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(n & 0xFF);
        return stringBuffer.toString();
    }

    public static String addressToString(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("IPv4 Address must be 4-bytes in length");
        }
        int n = IPv4Address.byteToInt(byArray[0]);
        int n2 = IPv4Address.byteToInt(byArray[1]);
        int n3 = IPv4Address.byteToInt(byArray[2]);
        int n4 = IPv4Address.byteToInt(byArray[3]);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n).append('.').append(n2).append('.').append(n3).append('.').append(n4);
        return stringBuffer.toString();
    }

    public IPv4Address() {
        this.m_addr = new byte[4];
        this.m_addr[0] = 0;
        this.m_addr[1] = 0;
        this.m_addr[2] = 0;
        this.m_addr[3] = 0;
    }

    public IPv4Address(IPv4Address iPv4Address) {
        this.m_addr = this.dup(iPv4Address.m_addr);
    }

    public IPv4Address(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Invalid address length");
        }
        this.m_addr = this.dup(byArray);
    }

    public IPv4Address(int n) {
        this.m_addr = new byte[4];
        this.m_addr[0] = (byte)(n >>> 24);
        this.m_addr[1] = (byte)(n >> 16 & 0xFF);
        this.m_addr[2] = (byte)(n >> 8 & 0xFF);
        this.m_addr[3] = (byte)(n & 0xFF);
    }

    public IPv4Address(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid Dotted Decimal IPv4 Address");
        }
        this.m_addr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("Invalid IPv4 Address string");
            }
            this.m_addr[i] = (byte)(n & 0xFF);
        }
    }

    public IPv4Address(InetAddress inetAddress) {
        this.m_addr = this.dup(inetAddress.getAddress());
    }

    public int getAddress() {
        int n = IPv4Address.byteToInt(this.m_addr[0]) << 24;
        n |= IPv4Address.byteToInt(this.m_addr[1]) << 16;
        n |= IPv4Address.byteToInt(this.m_addr[2]) << 8;
        return n |= IPv4Address.byteToInt(this.m_addr[3]);
    }

    public byte[] getAddressBytes() {
        return this.m_addr;
    }

    public void setAddress(IPv4Address iPv4Address) {
        this.m_addr = this.dup(iPv4Address.m_addr);
    }

    public void setAddress(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Invalid address length");
        }
        this.m_addr = this.dup(byArray);
    }

    public void setAddress(int n) {
        this.m_addr = new byte[4];
        this.m_addr[0] = (byte)(n >>> 24);
        this.m_addr[1] = (byte)(n >> 16 & 0xFF);
        this.m_addr[2] = (byte)(n >> 8 & 0xFF);
        this.m_addr[3] = (byte)(n & 0xFF);
    }

    public void setAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid Dotted Decimal IPv4 Address");
        }
        this.m_addr = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("Invalid IPv4 Address string");
            }
            this.m_addr[i] = (byte)(n & 0xFF);
        }
    }

    public void setAddress(InetAddress inetAddress) {
        this.m_addr = this.dup(inetAddress.getAddress());
    }

    public boolean equals(Object object) {
        boolean bl;
        block4: {
            block5: {
                block3: {
                    bl = false;
                    if (!(object instanceof IPv4Address)) break block3;
                    byte[] byArray = ((IPv4Address)object).m_addr;
                    bl = true;
                    for (int i = 0; i < 4; ++i) {
                        if (this.m_addr[i] == byArray[i]) continue;
                        bl = false;
                    }
                    break block4;
                }
                if (!(object instanceof Integer)) break block5;
                if (((Integer)object).intValue() != this.getAddress()) break block4;
                bl = true;
                break block4;
            }
            if (!(object instanceof String)) break block4;
            try {
                IPv4Address iPv4Address = new IPv4Address((String)object);
                bl = this.equals(iPv4Address);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        return IPv4Address.addressToString(this.m_addr);
    }
}

