/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.util.Date;
import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class TimestampReply
extends ICMPHeader {
    private int m_origStamp;
    private int m_recvStamp;
    private int m_xmitStamp;

    public TimestampReply() {
        super((byte)14, (byte)0);
        this.m_recvStamp = this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
        this.m_xmitStamp = this.m_origStamp;
    }

    public TimestampReply(byte[] byArray, int n) {
        this.loadFromBuffer(byArray, n);
    }

    public final void computeChecksum() {
        OC16ChecksumProducer oC16ChecksumProducer = new OC16ChecksumProducer();
        super.computeChecksum(oC16ChecksumProducer);
        oC16ChecksumProducer.add(this.m_origStamp);
        oC16ChecksumProducer.add(this.m_recvStamp);
        oC16ChecksumProducer.add(this.m_xmitStamp);
        this.setChecksum(oC16ChecksumProducer.getChecksum());
    }

    public final int storeToBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 20) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        n = super.storeToBuffer(byArray, n);
        byArray[n++] = (byte)(this.m_origStamp >> 24 & 0xFF);
        byArray[n++] = (byte)(this.m_origStamp >> 16 & 0xFF);
        byArray[n++] = (byte)(this.m_origStamp >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_origStamp & 0xFF);
        byArray[n++] = (byte)(this.m_recvStamp >> 24 & 0xFF);
        byArray[n++] = (byte)(this.m_recvStamp >> 16 & 0xFF);
        byArray[n++] = (byte)(this.m_recvStamp >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_recvStamp & 0xFF);
        byArray[n++] = (byte)(this.m_xmitStamp >> 24 & 0xFF);
        byArray[n++] = (byte)(this.m_xmitStamp >> 16 & 0xFF);
        byArray[n++] = (byte)(this.m_xmitStamp >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_xmitStamp & 0xFF);
        return n;
    }

    public final int loadFromBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 20) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        n = super.loadFromBuffer(byArray, n);
        if (this.getType() != 14) {
            throw new IllegalArgumentException("The buffer did not contain an Timestamp Reply");
        }
        this.m_origStamp = TimestampReply.byteToInt(byArray[n++]) << 24 | TimestampReply.byteToInt(byArray[n++]) << 16 | TimestampReply.byteToInt(byArray[n++]) << 8 | TimestampReply.byteToInt(byArray[n++]);
        this.m_recvStamp = TimestampReply.byteToInt(byArray[n++]) << 24 | TimestampReply.byteToInt(byArray[n++]) << 16 | TimestampReply.byteToInt(byArray[n++]) << 8 | TimestampReply.byteToInt(byArray[n++]);
        this.m_xmitStamp = TimestampReply.byteToInt(byArray[n++]) << 24 | TimestampReply.byteToInt(byArray[n++]) << 16 | TimestampReply.byteToInt(byArray[n++]) << 8 | TimestampReply.byteToInt(byArray[n++]);
        return n;
    }

    public final void setOriginateTS() {
        this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setOriginateTS(int n) {
        this.m_origStamp = n;
    }

    public final int getOriginateTS() {
        return this.m_origStamp;
    }

    public final void setReceiveTS() {
        this.m_recvStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setReceiveTS(int n) {
        this.m_recvStamp = n;
    }

    public final int getReceiveTS() {
        return this.m_recvStamp;
    }

    public final void setTransmitTS() {
        this.m_xmitStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setTransmitTS(int n) {
        this.m_xmitStamp = n;
    }

    public final int getTransmitTS() {
        return this.m_xmitStamp;
    }

    public final byte[] toBytes() {
        byte[] byArray = new byte[20];
        this.storeToBuffer(byArray, 0);
        return byArray;
    }
}

