/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class ICMPEchoPacket
extends ICMPHeader {
    private static final byte[] NAMED_PAD = new byte[]{79, 112, 101, 110, 78, 77, 83, 33};
    private long m_sent;
    private long m_recv;
    private long m_tid;
    private byte[] m_pad;
    private long m_rtt;
    private static final int PAD_SIZE = 16;

    private static long byteToLong(byte by) {
        long l = by;
        if (l < 0L) {
            l += 256L;
        }
        return l;
    }

    private ICMPEchoPacket() {
        throw new UnsupportedOperationException("illegal constructor call");
    }

    public ICMPEchoPacket(long l) {
        super((byte)8, (byte)0);
        int n;
        this.setNextSequenceId();
        this.m_rtt = 0L;
        this.m_sent = 0L;
        this.m_recv = 0L;
        this.m_tid = l;
        this.m_pad = new byte[16];
        for (n = 0; n < NAMED_PAD.length && n < 16; ++n) {
            this.m_pad[n] = NAMED_PAD[n];
        }
        for (n = NAMED_PAD.length; n < 16; ++n) {
            this.m_pad[n] = (byte)n;
        }
    }

    public ICMPEchoPacket(byte[] byArray) {
        this.m_pad = null;
        this.loadFromBuffer(byArray, 0);
    }

    public final long getSentTime() {
        return this.m_sent;
    }

    public final long setSentTime() {
        this.m_sent = System.currentTimeMillis();
        return this.m_sent;
    }

    public final void setSentTime(long l) {
        this.m_sent = l;
    }

    public final long getReceivedTime() {
        return this.m_recv;
    }

    public final long setReceivedTime() {
        this.m_recv = System.currentTimeMillis();
        return this.m_recv;
    }

    public final void setReceivedTime(long l) {
        this.m_recv = l;
    }

    public final void setPingRTT(long l) {
        this.m_rtt = l;
    }

    public final long getPingRTT() {
        return this.m_rtt;
    }

    public static final int getNetworkSize() {
        return ICMPHeader.getNetworkSize() + 32 + 16;
    }

    public final void computeChecksum() {
        OC16ChecksumProducer oC16ChecksumProducer = new OC16ChecksumProducer();
        super.computeChecksum(oC16ChecksumProducer);
        oC16ChecksumProducer.add(this.m_rtt);
        oC16ChecksumProducer.add(this.m_sent);
        oC16ChecksumProducer.add(this.m_recv);
        oC16ChecksumProducer.add(this.m_tid);
        int n = this.m_pad.length - this.m_pad.length % 2;
        for (int i = 0; i < n; i += 2) {
            oC16ChecksumProducer.add(this.m_pad[i], this.m_pad[i + 1]);
        }
        if (this.m_pad.length % 1 == 1) {
            oC16ChecksumProducer.add(this.m_pad[this.m_pad.length]);
        }
        super.setChecksum(oC16ChecksumProducer.getChecksum());
    }

    public final long getTID() {
        return this.m_tid;
    }

    public final void setTID(long l) {
        this.m_tid = l;
    }

    public final int loadFromBuffer(byte[] byArray, int n) {
        int n2;
        if (byArray.length - n < ICMPEchoPacket.getNetworkSize()) {
            throw new IndexOutOfBoundsException("Insufficient Data");
        }
        n = super.loadFromBuffer(byArray, n);
        if (!this.isEchoReply() && !this.isEchoRequest()) {
            throw new IllegalArgumentException("Invalid type, must be echo request/reply packet");
        }
        this.m_sent = 0L;
        for (n2 = 0; n2 < 8; ++n2) {
            this.m_sent <<= 8;
            this.m_sent |= ICMPEchoPacket.byteToLong(byArray[n++]);
        }
        this.m_recv = 0L;
        for (n2 = 0; n2 < 8; ++n2) {
            this.m_recv <<= 8;
            this.m_recv |= ICMPEchoPacket.byteToLong(byArray[n++]);
        }
        this.m_tid = 0L;
        for (n2 = 0; n2 < 8; ++n2) {
            this.m_tid <<= 8;
            this.m_tid |= ICMPEchoPacket.byteToLong(byArray[n++]);
        }
        this.m_rtt = 0L;
        for (n2 = 0; n2 < 8; ++n2) {
            this.m_rtt <<= 8;
            this.m_rtt |= ICMPEchoPacket.byteToLong(byArray[n++]);
        }
        if (this.m_pad == null) {
            this.m_pad = new byte[16];
        }
        for (n2 = 0; n2 < 16; ++n2) {
            this.m_pad[n2] = byArray[n++];
        }
        return n;
    }

    public final int storeToBuffer(byte[] byArray, int n) {
        int n2;
        if (byArray.length - n < ICMPEchoPacket.getNetworkSize()) {
            throw new IndexOutOfBoundsException("Insufficient Buffer Size");
        }
        n = super.storeToBuffer(byArray, n);
        long l = this.m_sent;
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n++] = (byte)(l >>> 56);
            l <<= 8;
        }
        l = this.m_recv;
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n++] = (byte)(l >>> 56);
            l <<= 8;
        }
        l = this.m_tid;
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n++] = (byte)(l >>> 56);
            l <<= 8;
        }
        l = this.m_rtt;
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n++] = (byte)(l >>> 56);
            l <<= 8;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            byArray[n++] = this.m_pad[n2];
        }
        return n;
    }

    public final byte[] toBytes() {
        byte[] byArray = new byte[ICMPEchoPacket.getNetworkSize()];
        this.storeToBuffer(byArray, 0);
        return byArray;
    }
}

