/*
 * Decompiled with CFR 0.152.
 */
package jnlp.sample.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import jnlp.sample.jardiff.JarDiff;
import jnlp.sample.servlet.DownloadRequest;
import jnlp.sample.servlet.DownloadResponse;
import jnlp.sample.servlet.ErrorResponseException;
import jnlp.sample.servlet.JnlpResource;
import jnlp.sample.servlet.Logger;
import jnlp.sample.servlet.ResourceCatalog;
import jnlp.sample.util.VersionString;

public class JarDiffHandler {
    private static final int BUF_SIZE = 32768;
    private static final String JARDIFF_MIMETYPE = "application/x-java-archive-diff";
    private HashMap _jarDiffEntries = new HashMap();
    private static Logger _log = null;
    private ServletContext _servletContext = null;
    private String _jarDiffMimeType = null;

    public JarDiffHandler(ServletContext servletContext, Logger log) {
        this._servletContext = servletContext;
        _log = log;
        this._jarDiffMimeType = this._servletContext.getMimeType("xyz.jardiff");
        if (this._jarDiffMimeType == null) {
            this._jarDiffMimeType = JARDIFF_MIMETYPE;
        }
    }

    public synchronized DownloadResponse getJarDiffEntry(ResourceCatalog catalog, DownloadRequest dreq, JnlpResource res) {
        if (dreq.getCurrentVersionId() == null) {
            return null;
        }
        boolean doJarDiffWorkAround = JarDiffHandler.isJavawsVersion(dreq, "1.0*");
        JarDiffKey key = new JarDiffKey(res.getName(), dreq.getCurrentVersionId(), res.getReturnVersionId(), !doJarDiffWorkAround);
        JarDiffEntry entry = (JarDiffEntry)this._jarDiffEntries.get(key);
        if (entry == null) {
            File f;
            if (_log.isInformationalLevel()) {
                _log.addInformational("servlet.log.info.jardiff.gen", res.getName(), dreq.getCurrentVersionId(), res.getReturnVersionId());
            }
            if ((f = this.generateJarDiff(catalog, dreq, res, doJarDiffWorkAround)) == null) {
                _log.addWarning("servlet.log.warning.jardiff.failed", res.getName(), dreq.getCurrentVersionId(), res.getReturnVersionId());
            }
            entry = new JarDiffEntry(f);
            this._jarDiffEntries.put(key, entry);
        }
        if (entry.getJarDiffFile() == null) {
            return null;
        }
        return DownloadResponse.getFileDownloadResponse(entry.getJarDiffFile(), this._jarDiffMimeType, entry.getJarDiffFile().lastModified(), res.getReturnVersionId());
    }

    public static boolean isJavawsVersion(DownloadRequest dreq, String version) {
        String javawsAgent = "javaws";
        String jwsVer = dreq.getHttpRequest().getHeader("User-Agent");
        if (!jwsVer.startsWith("javaws-")) {
            StringTokenizer st = new StringTokenizer(jwsVer);
            while (st.hasMoreTokens()) {
                String verString = st.nextToken();
                int index = verString.indexOf(javawsAgent);
                if (index == -1) continue;
                verString = verString.substring(index + javawsAgent.length() + 1);
                return VersionString.contains(version, verString);
            }
            return false;
        }
        int startIndex = jwsVer.indexOf("-");
        if (startIndex == -1) {
            return false;
        }
        int endIndex = jwsVer.indexOf("/");
        if (endIndex == -1 || endIndex < startIndex) {
            return false;
        }
        String verId = jwsVer.substring(startIndex + 1, endIndex);
        return VersionString.contains(version, verId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean download(URL target, File file) {
        _log.addDebug("JarDiffHandler:  Doing download");
        boolean ret = true;
        boolean delete = false;
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(target.openStream());
            out = new BufferedOutputStream(new FileOutputStream(file));
            int read = 0;
            int totalRead = 0;
            byte[] buf = new byte[32768];
            while ((read = in.read(buf)) != -1) {
                ((BufferedOutputStream)out).write(buf, 0, read);
                totalRead += read;
            }
            _log.addDebug("total read: " + totalRead);
            _log.addDebug("Wrote URL " + target.toString() + " to file " + file);
        }
        catch (IOException ioe) {
            _log.addDebug("Got exception while downloading resource: " + ioe);
            ret = false;
            if (file != null) {
                delete = true;
            }
        }
        finally {
            try {
                in.close();
                in = null;
            }
            catch (IOException ioe) {
                _log.addDebug("Got exception while downloading resource: " + ioe);
            }
            try {
                out.close();
                out = null;
            }
            catch (IOException ioe) {
                _log.addDebug("Got exception while downloading resource: " + ioe);
            }
            if (delete) {
                file.delete();
            }
        }
        return ret;
    }

    private String getRealPath(String path) throws IOException {
        File newFile;
        URL fileURL = this._servletContext.getResource(path);
        File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        if (fileURL != null && this.download(fileURL, newFile = File.createTempFile("temp", ".jar", tempDir))) {
            String filePath = newFile.getPath();
            return filePath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File generateJarDiff(ResourceCatalog catalog, DownloadRequest dreq, JnlpResource res, boolean doJarDiffWorkAround) {
        boolean del_old = false;
        boolean del_new = false;
        DownloadRequest fromDreq = dreq.getFromDownloadRequest();
        try {
            JnlpResource fromRes = catalog.lookupResource(fromDreq);
            String newFilePath = this._servletContext.getRealPath(res.getPath());
            String oldFilePath = this._servletContext.getRealPath(fromRes.getPath());
            if (newFilePath == null && (newFilePath = this.getRealPath(res.getPath())) != null) {
                del_new = true;
            }
            if (oldFilePath == null && (oldFilePath = this.getRealPath(fromRes.getPath())) != null) {
                del_old = true;
            }
            if (newFilePath == null) return null;
            if (oldFilePath == null) {
                return null;
            }
            File tempDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
            File outputFile = File.createTempFile("jnlp", ".jardiff", tempDir);
            _log.addDebug("Generating Jardiff between " + oldFilePath + " and " + newFilePath + " Store in " + outputFile);
            FileOutputStream os = new FileOutputStream(outputFile);
            JarDiff.createPatch((String)oldFilePath, (String)newFilePath, (OutputStream)os, (!doJarDiffWorkAround ? 1 : 0) != 0);
            ((OutputStream)os).close();
            try {
                if (outputFile.length() >= new File(newFilePath).length()) {
                    _log.addDebug("JarDiff discarded - since it is bigger");
                    File file = null;
                    return file;
                }
                File newFilePacked = new File(newFilePath + ".pack.gz");
                if (newFilePacked.exists()) {
                    _log.addDebug("generated jardiff size: " + outputFile.length());
                    _log.addDebug("packed requesting file size: " + newFilePacked.length());
                    if (outputFile.length() >= newFilePacked.length()) {
                        _log.addDebug("JarDiff discarded - packed version of requesting file is smaller");
                        File file = null;
                        return file;
                    }
                }
                _log.addDebug("JarDiff generation succeeded");
                File file = outputFile;
                return file;
            }
            finally {
                if (del_new) {
                    new File(newFilePath).delete();
                }
                if (del_old) {
                    new File(oldFilePath).delete();
                }
            }
        }
        catch (IOException ioe) {
            _log.addDebug("Failed to genereate jardiff", ioe);
            return null;
        }
        catch (ErrorResponseException ere) {
            _log.addDebug("Failed to genereate jardiff", ere);
            return null;
        }
    }

    private static class JarDiffEntry {
        private File _jardiffFile;

        public JarDiffEntry(File jarDiffFile) {
            this._jardiffFile = jarDiffFile;
        }

        public File getJarDiffFile() {
            return this._jardiffFile;
        }
    }

    private static class JarDiffKey
    implements Comparable {
        private String _name;
        private String _fromVersionId;
        private String _toVersionId;
        private boolean _minimal;

        public JarDiffKey(String name, String fromVersionId, String toVersionId, boolean minimal) {
            this._name = name;
            this._fromVersionId = fromVersionId;
            this._toVersionId = toVersionId;
            this._minimal = minimal;
        }

        public String getName() {
            return this._name;
        }

        public String getFromVersionId() {
            return this._fromVersionId;
        }

        public String getToVersionId() {
            return this._toVersionId;
        }

        public boolean isMinimal() {
            return this._minimal;
        }

        public int compareTo(Object o) {
            if (!(o instanceof JarDiffKey)) {
                return -1;
            }
            JarDiffKey other = (JarDiffKey)o;
            int n = this._name.compareTo(other.getName());
            if (n != 0) {
                return n;
            }
            n = this._fromVersionId.compareTo(other.getFromVersionId());
            if (n != 0) {
                return n;
            }
            if (this._minimal != other.isMinimal()) {
                return -1;
            }
            return this._toVersionId.compareTo(other.getToVersionId());
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            return this._name.hashCode() + this._fromVersionId.hashCode() + this._toVersionId.hashCode();
        }
    }
}

