/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.jrobin;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;
import org.jrobin.core.FetchData;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.Sample;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.opennms.core.utils.StringUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdConfig;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.jrobin.JRobinRrdGraphDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRobinRrdStrategy
implements RrdStrategy {
    private boolean m_initialized = false;

    public void closeFile(Object rrdFile) throws Exception {
        ((RrdDb)rrdFile).close();
    }

    public Object createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        File f = new File(directory);
        f.mkdirs();
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        if (new File(fileName).exists()) {
            return null;
        }
        RrdDef def = new RrdDef(fileName);
        def.setStartTime(1000L);
        def.setStep((long)step);
        for (RrdDataSource dataSource : dataSources) {
            String dsMin = dataSource.getMin();
            String dsMax = dataSource.getMax();
            double min = dsMin == null || "U".equals(dsMin) ? Double.NaN : Double.parseDouble(dsMin);
            double max = dsMax == null || "U".equals(dsMax) ? Double.NaN : Double.parseDouble(dsMax);
            def.addDatasource(dataSource.getName(), dataSource.getType(), (long)dataSource.getHeartBeat(), min, max);
        }
        for (String rra : rraList) {
            def.addArchive(rra);
        }
        return def;
    }

    public void createFile(Object rrdDef) throws Exception {
        if (rrdDef == null) {
            return;
        }
        RrdDb rrd = new RrdDb((RrdDef)rrdDef);
        rrd.close();
    }

    public Object openFile(String fileName) throws Exception {
        RrdDb rrd = new RrdDb(fileName);
        return rrd;
    }

    public void updateFile(Object rrdFile, String owner, String data) throws Exception {
        Sample sample = ((RrdDb)rrdFile).createSample();
        sample.setAndUpdate(data);
    }

    public synchronized void initialize() throws Exception {
        if (!this.m_initialized) {
            RrdDb.setDefaultFactory((String)"FILE");
            String factory = RrdConfig.getProperty((String)"org.jrobin.core.RrdBackendFactory", (String)"FILE");
            RrdDb.setDefaultFactory((String)factory);
            String home = System.getProperty("opennms.home");
            System.setProperty("jrobin.fontdir", home + File.separator + "etc");
            this.m_initialized = true;
        }
    }

    public void graphicsInitialize() throws Exception {
        this.initialize();
    }

    public Double fetchLastValue(String fileName, String ds, int interval) throws NumberFormatException, RrdException {
        return this.fetchLastValue(fileName, ds, "AVERAGE", interval);
    }

    public Double fetchLastValue(String fileName, String ds, String consolidationFunction, int interval) throws RrdException {
        RrdDb rrd = null;
        try {
            long now = System.currentTimeMillis();
            long collectTime = (now - now % (long)interval) / 1000L;
            rrd = new RrdDb(fileName);
            FetchData data = rrd.createFetchRequest(consolidationFunction, collectTime, collectTime).fetchData();
            this.log().debug((Object)data.toString());
            double[] vals = data.getValues(ds);
            if (vals.length > 0) {
                Double d = new Double(vals[vals.length - 1]);
                return d;
            }
            Double d = null;
            return d;
        }
        catch (IOException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        catch (org.jrobin.core.RrdException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        finally {
            if (rrd != null) {
                try {
                    rrd.close();
                }
                catch (IOException e) {
                    this.log().error((Object)("Failed to close rrd file: " + fileName), (Throwable)e);
                }
            }
        }
    }

    public Double fetchLastValueInRange(String fileName, String ds, int interval, int range) throws NumberFormatException, RrdException {
        RrdDb rrd = null;
        try {
            rrd = new RrdDb(fileName);
            long now = System.currentTimeMillis();
            long latestUpdateTime = (now - now % (long)interval) / 1000L;
            long earliestUpdateTime = (now - now % (long)interval - (long)range) / 1000L;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("fetchInRange: fetching data from " + earliestUpdateTime + " to " + latestUpdateTime));
            }
            FetchData data = rrd.createFetchRequest("AVERAGE", earliestUpdateTime, latestUpdateTime).fetchData();
            double[] vals = data.getValues(ds);
            long[] times = data.getTimestamps();
            for (int i = vals.length - 1; i >= 0; --i) {
                if (Double.isNaN(vals[i])) {
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug((Object)("fetchInRange: Got a NaN value at interval: " + times[i] + " continuing back in time"));
                    continue;
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Got a non NaN value at interval: " + times[i] + " : " + vals[i]));
                }
                Double d = new Double(vals[i]);
                return d;
            }
            Double d = null;
            return d;
        }
        catch (IOException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        catch (org.jrobin.core.RrdException e) {
            throw new RrdException("Exception occurred fetching data from " + fileName, (Throwable)e);
        }
        finally {
            if (rrd != null) {
                try {
                    rrd.close();
                }
                catch (IOException e) {
                    this.log().error((Object)("Failed to close rrd file: " + fileName), (Throwable)e);
                }
            }
        }
    }

    private Color getColor(String colorValue) {
        int colorVal = Integer.parseInt(colorValue, 16);
        return new Color(colorVal);
    }

    private Color getColorOrInvisible(String[] array, int index) {
        if (array.length > index) {
            return this.getColor(array[index]);
        }
        return new Color(1.0f, 1.0f, 1.0f, 0.0f);
    }

    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return this.createGraphReturnDetails(command, workDir).getInputStream();
    }

    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException, RrdException {
        try {
            String[] commandArray = this.tokenize(command, " \t", false);
            RrdGraphDef graphDef = this.createGraphDef(workDir, commandArray);
            graphDef.setSignature("OpenNMS/JRobin");
            RrdGraph graph = new RrdGraph(graphDef);
            return new JRobinRrdGraphDetails(graph, command);
        }
        catch (Exception e) {
            this.log().error((Object)("JRobin: exception occurred creating graph: " + e.getMessage()), (Throwable)e);
            throw new RrdException("An exception occurred creating the graph: " + e.getMessage(), (Throwable)e);
        }
    }

    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
    }

    protected RrdGraphDef createGraphDef(File workDir, String[] commandArray) throws org.jrobin.core.RrdException {
        RrdGraphDef graphDef = new RrdGraphDef();
        graphDef.setImageFormat("PNG");
        long start = 0L;
        long end = 0L;
        int height = 100;
        int width = 400;
        double lowerLimit = Double.NaN;
        double upperLimit = Double.NaN;
        boolean rigid = false;
        for (int i = 0; i < commandArray.length; ++i) {
            String format;
            String[] color;
            String arg = commandArray[i];
            if (arg.startsWith("--start=")) {
                start = Long.parseLong(arg.substring("--start=".length()));
                this.log().debug((Object)("JRobin start time: " + start));
                continue;
            }
            if (arg.equals("--start")) {
                if (i + 1 < commandArray.length) {
                    start = Long.parseLong(commandArray[++i]);
                    this.log().debug((Object)("JRobin start time: " + start));
                    continue;
                }
                throw new IllegalArgumentException("--start must be followed by a start time");
            }
            if (arg.startsWith("--end=")) {
                end = Long.parseLong(arg.substring("--end=".length()));
                this.log().debug((Object)("JRobin end time: " + end));
                continue;
            }
            if (arg.equals("--end")) {
                if (i + 1 < commandArray.length) {
                    end = Long.parseLong(commandArray[++i]);
                    this.log().debug((Object)("JRobin end time: " + end));
                    continue;
                }
                throw new IllegalArgumentException("--end must be followed by an end time");
            }
            if (arg.startsWith("--title=")) {
                String[] title = this.tokenize(arg, "=", true);
                graphDef.setTitle(title[1]);
                continue;
            }
            if (arg.equals("--title")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setTitle(commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--title must be followed by a title");
            }
            if (arg.startsWith("--color=")) {
                String[] color2 = this.tokenize(arg, "=", true);
                this.parseGraphColor(graphDef, color2[1]);
                continue;
            }
            if (arg.equals("--color") || arg.equals("-c")) {
                if (i + 1 < commandArray.length) {
                    this.parseGraphColor(graphDef, commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--color must be followed by a color");
            }
            if (arg.startsWith("--vertical-label=")) {
                String[] label = this.tokenize(arg, "=", true);
                graphDef.setVerticalLabel(label[1]);
                continue;
            }
            if (arg.equals("--vertical-label")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setVerticalLabel(commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--vertical-label must be followed by a label");
            }
            if (arg.startsWith("--height=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                height = Integer.parseInt(argParm[1]);
                this.log().debug((Object)("JRobin height: " + height));
                continue;
            }
            if (arg.equals("--height")) {
                if (i + 1 < commandArray.length) {
                    height = Integer.parseInt(commandArray[++i]);
                    this.log().debug((Object)("JRobin height: " + height));
                    continue;
                }
                throw new IllegalArgumentException("--height must be followed by a number");
            }
            if (arg.startsWith("--width=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                width = Integer.parseInt(argParm[1]);
                this.log().debug((Object)("JRobin width: " + height));
                continue;
            }
            if (arg.equals("--width")) {
                if (i + 1 < commandArray.length) {
                    width = Integer.parseInt(commandArray[++i]);
                    this.log().debug((Object)("JRobin width: " + height));
                    continue;
                }
                throw new IllegalArgumentException("--width must be followed by a number");
            }
            if (arg.startsWith("--units-exponent=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                int exponent = Integer.parseInt(argParm[1]);
                this.log().debug((Object)("JRobin units exponent: " + exponent));
                graphDef.setUnitsExponent(exponent);
                continue;
            }
            if (arg.equals("--units-exponent")) {
                if (i + 1 < commandArray.length) {
                    int exponent = Integer.parseInt(commandArray[++i]);
                    this.log().debug((Object)("JRobin units exponent: " + exponent));
                    graphDef.setUnitsExponent(exponent);
                    continue;
                }
                throw new IllegalArgumentException("--units-exponent must be followed by a number");
            }
            if (arg.startsWith("--lower-limit=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                lowerLimit = Double.parseDouble(argParm[1]);
                this.log().debug((Object)("JRobin lower limit: " + lowerLimit));
                continue;
            }
            if (arg.equals("--lower-limit")) {
                if (i + 1 < commandArray.length) {
                    lowerLimit = Double.parseDouble(commandArray[++i]);
                    this.log().debug((Object)("JRobin lower limit: " + lowerLimit));
                    continue;
                }
                throw new IllegalArgumentException("--lower-limit must be followed by a number");
            }
            if (arg.startsWith("--upper-limit=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                upperLimit = Double.parseDouble(argParm[1]);
                this.log().debug((Object)("JRobin upp limit: " + upperLimit));
                continue;
            }
            if (arg.equals("--upper-limit")) {
                if (i + 1 < commandArray.length) {
                    upperLimit = Double.parseDouble(commandArray[++i]);
                    this.log().debug((Object)("JRobin upper limit: " + upperLimit));
                    continue;
                }
                throw new IllegalArgumentException("--upper-limit must be followed by a number");
            }
            if (arg.startsWith("--base=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                graphDef.setBase(Double.parseDouble(argParm[1]));
                continue;
            }
            if (arg.equals("--base")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setBase(Double.parseDouble(commandArray[++i]));
                    continue;
                }
                throw new IllegalArgumentException("--base must be followed by a number");
            }
            if (arg.startsWith("--font=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                this.processRrdFontArgument(graphDef, argParm[1]);
                continue;
            }
            if (arg.equals("--font")) {
                if (i + 1 < commandArray.length) {
                    this.processRrdFontArgument(graphDef, commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--font must be followed by an argument");
            }
            if (arg.startsWith("--imgformat=")) {
                String[] argParm = this.tokenize(arg, "=", true);
                graphDef.setImageFormat(argParm[1]);
                continue;
            }
            if (arg.equals("--imgformat")) {
                if (i + 1 < commandArray.length) {
                    graphDef.setImageFormat(commandArray[++i]);
                    continue;
                }
                throw new IllegalArgumentException("--imgformat must be followed by an argument");
            }
            if (arg.equals("--rigid")) {
                rigid = true;
                continue;
            }
            if (arg.startsWith("DEF:")) {
                String definition = arg.substring("DEF:".length());
                String[] def = definition.split(":");
                String[] ds = def[0].split("=");
                File dsFile = new File(workDir, ds[1]);
                graphDef.datasource(ds[0], dsFile.getAbsolutePath(), def[1], def[2]);
                continue;
            }
            if (arg.startsWith("CDEF:")) {
                String definition = arg.substring("CDEF:".length());
                String[] cdef = this.tokenize(definition, "=", true);
                graphDef.datasource(cdef[0], cdef[1]);
                continue;
            }
            if (arg.startsWith("LINE1:")) {
                String definition = arg.substring("LINE1:".length());
                String[] line1 = this.tokenize(definition, ":", true);
                color = this.tokenize(line1[0], "#", true);
                graphDef.line(color[0], (Paint)this.getColorOrInvisible(color, 1), line1.length > 1 ? line1[1] : "");
                continue;
            }
            if (arg.startsWith("LINE2:")) {
                String definition = arg.substring("LINE2:".length());
                String[] line2 = this.tokenize(definition, ":", true);
                color = this.tokenize(line2[0], "#", true);
                graphDef.line(color[0], (Paint)this.getColorOrInvisible(color, 1), line2.length > 1 ? line2[1] : "", 2.0f);
                continue;
            }
            if (arg.startsWith("LINE3:")) {
                String definition = arg.substring("LINE3:".length());
                String[] line3 = this.tokenize(definition, ":", true);
                color = this.tokenize(line3[0], "#", true);
                graphDef.line(color[0], (Paint)this.getColorOrInvisible(color, 1), line3.length > 1 ? line3[1] : "", 3.0f);
                continue;
            }
            if (arg.startsWith("GPRINT:")) {
                String definition = arg.substring("GPRINT:".length());
                String[] gprint = this.tokenize(definition, ":", true);
                format = gprint[2];
                format = format.replaceAll("\\n", "\\\\l");
                graphDef.gprint(gprint[0], gprint[1], format);
                continue;
            }
            if (arg.startsWith("PRINT:")) {
                String definition = arg.substring("PRINT:".length());
                String[] print = this.tokenize(definition, ":", true);
                format = print[2];
                format = format.replaceAll("\\n", "\\\\l");
                graphDef.print(print[0], print[1], format);
                continue;
            }
            if (arg.startsWith("COMMENT:")) {
                String[] comments = this.tokenize(arg, ":", true);
                String format2 = comments[1].replaceAll("\\n", "\\\\l");
                graphDef.comment(format2);
                continue;
            }
            if (arg.startsWith("AREA:")) {
                String definition = arg.substring("AREA:".length());
                String[] area = this.tokenize(definition, ":", true);
                color = this.tokenize(area[0], "#", true);
                if (area.length > 1) {
                    graphDef.area(color[0], (Paint)this.getColorOrInvisible(color, 1), area[1]);
                    continue;
                }
                graphDef.area(color[0], (Paint)this.getColorOrInvisible(color, 1));
                continue;
            }
            if (arg.startsWith("STACK:")) {
                String definition = arg.substring("STACK:".length());
                String[] stack = this.tokenize(definition, ":", true);
                color = this.tokenize(stack[0], "#", true);
                graphDef.stack(color[0], (Paint)this.getColor(color[1]), stack.length > 1 ? stack[1] : "");
                continue;
            }
            this.log().warn((Object)("JRobin: Unrecognized graph argument: " + arg));
        }
        graphDef.setTimeSpan(start, end);
        graphDef.setMinValue(lowerLimit);
        graphDef.setMaxValue(upperLimit);
        graphDef.setRigid(rigid);
        graphDef.setHeight(height);
        graphDef.setWidth(width);
        this.log().debug((Object)("JRobin Finished tokenizing checking: start time: " + start + "; end time: " + end));
        this.log().debug((Object)("large font = " + graphDef.getLargeFont() + ", small font = " + graphDef.getSmallFont()));
        return graphDef;
    }

    private void processRrdFontArgument(RrdGraphDef graphDef, String argParm) {
    }

    private String[] tokenize(String line, String delimiters, boolean processQuotes) {
        String passthroughTokens = "lcrjgsJ";
        return StringUtils.tokenizeWithQuotingAndEscapes((String)line, (String)delimiters, (boolean)processQuotes, (String)passthroughTokens);
    }

    private void parseGraphColor(RrdGraphDef graphDef, String colorArg) throws IllegalArgumentException {
        block13: {
            String[] colorArgParts = this.tokenize(colorArg, "#", false);
            if (colorArgParts.length != 2) {
                throw new IllegalArgumentException("--color must be followed by value with format COLORTAG#RRGGBB");
            }
            String colorTag = colorArgParts[0].toUpperCase();
            String colorHex = colorArgParts[1].toUpperCase();
            if (colorHex.length() != 6) {
                throw new IllegalArgumentException("--color must be followed by value with format COLORTAG#RRGGBB");
            }
            Color color = this.getColor(colorHex);
            try {
                if (colorTag.equals("BACK")) {
                    graphDef.setColor("BACK", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("CANVAS")) {
                    graphDef.setColor("CANVAS", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("SHADEA")) {
                    graphDef.setColor("SHADEA", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("SHADEB")) {
                    graphDef.setColor("SHADEB", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("GRID")) {
                    graphDef.setColor("GRID", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("MGRID")) {
                    graphDef.setColor("MGRID", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("FONT")) {
                    graphDef.setColor("FONT", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("FRAME")) {
                    graphDef.setColor("FRAME", (Paint)color);
                    break block13;
                }
                if (colorTag.equals("ARROW")) {
                    graphDef.setColor("ARROW", (Paint)color);
                    break block13;
                }
                throw new org.jrobin.core.RrdException("Unknown color tag " + colorTag);
            }
            catch (Exception e) {
                this.log().error((Object)("JRobin: exception occurred creating graph: " + e), (Throwable)e);
            }
        }
    }

    public String getStats() {
        return "";
    }

    public int getGraphLeftOffset() {
        return 74;
    }

    public int getGraphRightOffset() {
        return -15;
    }

    public int getGraphTopOffsetWithText() {
        return -61;
    }

    public String getDefaultFileExtension() {
        return ".jrb";
    }

    private final Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

