/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import jcifs.UniAddress;
import jcifs.netbios.Name;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NbtException;
import jcifs.netbios.SessionRequestPacket;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.BufferCache;
import jcifs.smb.DfsReferral;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComBlankResponse;
import jcifs.smb.SmbComNegotiate;
import jcifs.smb.SmbComNegotiateResponse;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbConstants;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2GetDfsReferral;
import jcifs.smb.Trans2GetDfsReferralResponse;
import jcifs.util.Encdec;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;
import jcifs.util.transport.Request;
import jcifs.util.transport.Response;
import jcifs.util.transport.Transport;
import jcifs.util.transport.TransportException;

public class SmbTransport
extends Transport
implements SmbConstants {
    static final byte[] BUF = new byte[65535];
    static final SmbComNegotiate NEGOTIATE_REQUEST = new SmbComNegotiate();
    static LogStream log = LogStream.getInstance();
    InetAddress localAddr;
    int localPort;
    UniAddress address;
    Socket socket;
    int port;
    int mid;
    OutputStream out;
    InputStream in;
    byte[] sbuf = new byte[255];
    SmbComBlankResponse key = new SmbComBlankResponse();
    long sessionExpiration = System.currentTimeMillis() + (long)SmbConstants.SO_TIMEOUT;
    LinkedList referrals = new LinkedList();
    SigningDigest digest = null;
    LinkedList sessions = new LinkedList();
    ServerData server = new ServerData();
    int flags2 = SmbConstants.FLAGS2;
    int maxMpxCount = SmbConstants.MAX_MPX_COUNT;
    int snd_buf_size = SmbConstants.SND_BUF_SIZE;
    int rcv_buf_size = SmbConstants.RCV_BUF_SIZE;
    int capabilities = SmbConstants.CAPABILITIES;
    int sessionKey = 0;
    boolean useUnicode = SmbConstants.USE_UNICODE;
    String tconHostName;

    static synchronized SmbTransport getSmbTransport(UniAddress address, int port) {
        return SmbTransport.getSmbTransport(address, port, SmbConstants.LADDR, SmbConstants.LPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized SmbTransport getSmbTransport(UniAddress address, int port, InetAddress localAddr, int localPort) {
        SmbTransport conn;
        LinkedList linkedList = SmbConstants.CONNECTIONS;
        synchronized (linkedList) {
            if (SmbConstants.SSN_LIMIT != 1) {
                ListIterator iter = SmbConstants.CONNECTIONS.listIterator();
                while (iter.hasNext()) {
                    conn = (SmbTransport)iter.next();
                    if (!conn.matches(address, port, localAddr, localPort) || SmbConstants.SSN_LIMIT != 0 && conn.sessions.size() >= SmbConstants.SSN_LIMIT) continue;
                    return conn;
                }
            }
            conn = new SmbTransport(address, port, localAddr, localPort);
            SmbConstants.CONNECTIONS.add(0, conn);
        }
        return conn;
    }

    SmbTransport(UniAddress address, int port, InetAddress localAddr, int localPort) {
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
    }

    synchronized SmbSession getSmbSession() {
        return this.getSmbSession(new NtlmPasswordAuthentication(null, null, null));
    }

    synchronized SmbSession getSmbSession(NtlmPasswordAuthentication auth) {
        long now;
        SmbSession ssn;
        ListIterator iter = this.sessions.listIterator();
        while (iter.hasNext()) {
            ssn = (SmbSession)iter.next();
            if (!ssn.matches(auth)) continue;
            ssn.auth = auth;
            return ssn;
        }
        if (SmbConstants.SO_TIMEOUT > 0 && this.sessionExpiration < (now = System.currentTimeMillis())) {
            this.sessionExpiration = now + (long)SmbConstants.SO_TIMEOUT;
            iter = this.sessions.listIterator();
            while (iter.hasNext()) {
                ssn = (SmbSession)iter.next();
                if (ssn.expiration >= now) continue;
                ssn.logoff(false);
            }
        }
        ssn = new SmbSession(this.address, this.port, this.localAddr, this.localPort, auth);
        ssn.transport = this;
        this.sessions.add(ssn);
        return ssn;
    }

    boolean matches(UniAddress address, int port, InetAddress localAddr, int localPort) {
        return address.equals(this.address) && (port == 0 || port == this.port || port == 445 && this.port == 139) && (localAddr == this.localAddr || localAddr != null && localAddr.equals(this.localAddr)) && localPort == this.localPort;
    }

    boolean hasCapability(int cap) throws SmbException {
        try {
            this.connect(SmbConstants.RESPONSE_TIMEOUT);
        }
        catch (IOException ioe) {
            throw new SmbException("", (Throwable)ioe);
        }
        return (this.capabilities & cap) == cap;
    }

    boolean isSignatureSetupRequired(NtlmPasswordAuthentication auth) {
        return (this.flags2 & 4) != 0 && this.digest == null && auth != NtlmPasswordAuthentication.NULL && !NtlmPasswordAuthentication.NULL.equals(auth);
    }

    void ssn139() throws IOException {
        Name calledName = new Name(this.address.firstCalledName(), 32, null);
        do {
            this.socket = this.localAddr == null ? new Socket(this.address.getHostAddress(), 139) : new Socket(this.address.getHostAddress(), 139, this.localAddr, this.localPort);
            this.socket.setSoTimeout(SmbConstants.SO_TIMEOUT);
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            SessionRequestPacket ssp = new SessionRequestPacket(calledName, NbtAddress.getLocalName());
            this.out.write(this.sbuf, 0, ssp.writeWireFormat(this.sbuf, 0));
            if (SmbTransport.readn(this.in, this.sbuf, 0, 4) < 4) {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw new SmbException("EOF during NetBIOS session request");
            }
            block1 : switch (this.sbuf[0] & 0xFF) {
                case 130: {
                    if (LogStream.level >= 4) {
                        log.println("session established ok with " + this.address);
                    }
                    return;
                }
                case 131: {
                    int errorCode = this.in.read() & 0xFF;
                    switch (errorCode) {
                        case 128: 
                        case 130: {
                            this.socket.close();
                            break block1;
                        }
                    }
                    this.disconnect(true);
                    throw new NbtException(2, errorCode);
                }
                case -1: {
                    this.disconnect(true);
                    throw new NbtException(2, -1);
                }
                default: {
                    this.disconnect(true);
                    throw new NbtException(2, 0);
                }
            }
        } while ((calledName.name = this.address.nextCalledName()) != null);
        throw new IOException("Failed to establish session with " + this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void negotiate(int port, ServerMessageBlock resp) throws IOException {
        byte[] byArray = this.sbuf;
        synchronized (this.sbuf) {
            if (port == 139) {
                this.ssn139();
            } else {
                if (port == 0) {
                    port = 445;
                }
                this.socket = this.localAddr == null ? new Socket(this.address.getHostAddress(), port) : new Socket(this.address.getHostAddress(), port, this.localAddr, this.localPort);
                this.socket.setSoTimeout(SmbConstants.SO_TIMEOUT);
                this.out = this.socket.getOutputStream();
                this.in = this.socket.getInputStream();
            }
            if (++this.mid == 32000) {
                this.mid = 1;
            }
            SmbTransport.NEGOTIATE_REQUEST.mid = this.mid;
            int n = NEGOTIATE_REQUEST.encode(this.sbuf, 4);
            Encdec.enc_uint32be(n & 0xFFFF, this.sbuf, 0);
            if (LogStream.level >= 4) {
                log.println(NEGOTIATE_REQUEST);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, this.sbuf, 4, n);
                }
            }
            this.out.write(this.sbuf, 0, 4 + n);
            this.out.flush();
            if (this.peekKey() == null) {
                throw new IOException("transport closed in negotiate");
            }
            int size = Encdec.dec_uint16be(this.sbuf, 2) & 0xFFFF;
            if (size < 33 || 4 + size > this.sbuf.length) {
                throw new IOException("Invalid payload size: " + size);
            }
            SmbTransport.readn(this.in, this.sbuf, 36, size - 32);
            resp.decode(this.sbuf, 4);
            if (LogStream.level >= 4) {
                log.println(resp);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, this.sbuf, 4, n);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void connect() throws SmbException {
        try {
            super.connect(SmbConstants.RESPONSE_TIMEOUT);
        }
        catch (TransportException te) {
            throw new SmbException("", (Throwable)te);
        }
    }

    protected void doConnect() throws IOException {
        SmbComNegotiateResponse resp = new SmbComNegotiateResponse(this.server);
        try {
            this.negotiate(this.port, resp);
        }
        catch (ConnectException ce) {
            this.port = this.port == 0 || this.port == 445 ? 139 : 445;
            this.negotiate(this.port, resp);
        }
        catch (NoRouteToHostException nr) {
            this.port = this.port == 0 || this.port == 445 ? 139 : 445;
            this.negotiate(this.port, resp);
        }
        if (resp.dialectIndex > 10) {
            throw new SmbException("This client does not support the negotiated dialect.");
        }
        this.tconHostName = this.address.getHostName();
        this.flags2 = this.server.signaturesRequired || this.server.signaturesEnabled && SmbConstants.SIGNPREF ? (this.flags2 |= 4) : (this.flags2 &= 0xFFFB);
        this.maxMpxCount = Math.min(this.maxMpxCount, this.server.maxMpxCount);
        if (this.maxMpxCount < 1) {
            this.maxMpxCount = 1;
        }
        this.snd_buf_size = Math.min(this.snd_buf_size, this.server.maxBufferSize);
        this.capabilities &= this.server.capabilities;
        if ((this.capabilities & 4) == 0) {
            if (SmbConstants.FORCE_UNICODE) {
                this.capabilities |= 4;
            } else {
                this.useUnicode = false;
                this.flags2 &= Short.MAX_VALUE;
            }
        }
    }

    protected void doDisconnect(boolean hard) throws IOException {
        ListIterator iter = this.sessions.listIterator();
        while (iter.hasNext()) {
            SmbSession ssn = (SmbSession)iter.next();
            ssn.logoff(hard);
        }
        this.socket.shutdownOutput();
        this.out.close();
        this.in.close();
        this.socket.close();
        this.digest = null;
    }

    protected void makeKey(Request request) throws IOException {
        if (++this.mid == 32000) {
            this.mid = 1;
        }
        ((ServerMessageBlock)request).mid = this.mid;
    }

    protected Request peekKey() throws IOException {
        int n;
        do {
            if ((n = SmbTransport.readn(this.in, this.sbuf, 0, 4)) >= 4) continue;
            return null;
        } while (this.sbuf[0] == -123);
        n = SmbTransport.readn(this.in, this.sbuf, 4, 32);
        if (n < 32) {
            return null;
        }
        if (LogStream.level >= 4) {
            log.println("New data read: " + this);
            Hexdump.hexdump(log, this.sbuf, 4, 32);
        }
        while (this.sbuf[0] != 0 || this.sbuf[1] != 0 || this.sbuf[4] != -1 || this.sbuf[5] != 83 || this.sbuf[6] != 77 || this.sbuf[7] != 66) {
            for (int i = 0; i < 35; ++i) {
                this.sbuf[i] = this.sbuf[i + 1];
            }
            int b = this.in.read();
            if (b == -1) {
                return null;
            }
            this.sbuf[35] = (byte)b;
        }
        this.key.mid = Encdec.dec_uint16le(this.sbuf, 34) & 0xFFFF;
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Request request) throws IOException {
        byte[] byArray = BUF;
        synchronized (BUF) {
            ServerMessageBlock smb = (ServerMessageBlock)request;
            int n = smb.encode(BUF, 4);
            Encdec.enc_uint32be(n & 0xFFFF, BUF, 0);
            if (LogStream.level >= 4) {
                do {
                    log.println(smb);
                } while (smb instanceof AndXServerMessageBlock && (smb = ((AndXServerMessageBlock)smb).andx) != null);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, BUF, 4, n);
                }
            }
            this.out.write(BUF, 0, 4 + n);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void doSend0(Request request) throws IOException {
        try {
            this.doSend(request);
        }
        catch (IOException ioe) {
            if (LogStream.level > 2) {
                ioe.printStackTrace(log);
            }
            try {
                this.disconnect(true);
            }
            catch (IOException ioe2) {
                ioe2.printStackTrace(log);
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRecv(Response response) throws IOException {
        ServerMessageBlock resp = (ServerMessageBlock)response;
        resp.useUnicode = this.useUnicode;
        byte[] byArray = BUF;
        synchronized (BUF) {
            System.arraycopy(this.sbuf, 0, BUF, 0, 36);
            int size = Encdec.dec_uint16be(BUF, 2) & 0xFFFF;
            if (size < 33 || 4 + size > this.rcv_buf_size) {
                throw new IOException("Invalid payload size: " + size);
            }
            if (resp.command == 46) {
                SmbComReadAndXResponse r = (SmbComReadAndXResponse)resp;
                int off = 32;
                SmbTransport.readn(this.in, BUF, 4 + off, 27);
                off += 27;
                resp.decode(BUF, 4);
                if (r.dataLength > 0) {
                    SmbTransport.readn(this.in, BUF, 4 + off, r.dataOffset - off);
                    SmbTransport.readn(this.in, r.b, r.off, r.dataLength);
                }
            } else {
                SmbTransport.readn(this.in, BUF, 36, size - 32);
                resp.decode(BUF, 4);
                if (resp instanceof SmbComTransactionResponse) {
                    ((SmbComTransactionResponse)resp).nextElement();
                }
            }
            if (this.digest != null && resp.errorCode == 0) {
                this.digest.verify(BUF, 4, resp);
            }
            if (LogStream.level >= 4) {
                log.println(response);
                if (LogStream.level >= 6) {
                    Hexdump.hexdump(log, BUF, 4, size);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected void doSkip() throws IOException {
        int size = Encdec.dec_uint16be(this.sbuf, 2) & 0xFFFF;
        if (size < 33 || 4 + size > this.rcv_buf_size) {
            this.in.skip(this.in.available());
        } else {
            this.in.skip(size - 32);
        }
    }

    void checkStatus(ServerMessageBlock req, ServerMessageBlock resp) throws SmbException {
        resp.errorCode = SmbException.getStatusByCode(resp.errorCode);
        switch (resp.errorCode) {
            case 0: {
                break;
            }
            case -1073741790: 
            case -1073741718: 
            case -1073741715: 
            case -1073741714: 
            case -1073741713: 
            case -1073741712: 
            case -1073741711: 
            case -1073741710: 
            case -1073741428: 
            case -1073741260: {
                throw new SmbAuthException(resp.errorCode);
            }
            case -1073741225: {
                if (req.auth == null) {
                    throw new SmbException(resp.errorCode, null);
                }
                DfsReferral dr = this.getDfsReferral(req.auth, req.path);
                this.referrals.add(dr);
                throw dr;
            }
            case -2147483643: {
                break;
            }
            default: {
                throw new SmbException(resp.errorCode, null);
            }
        }
        if (resp.verifyFailed) {
            throw new SmbException("Signature verification failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        block24: {
            this.connect();
            request.flags2 |= this.flags2;
            request.useUnicode = this.useUnicode;
            request.response = response;
            if (request.digest == null) {
                request.digest = this.digest;
            }
            try {
                if (response == null) {
                    this.doSend0(request);
                    return;
                }
                if (request instanceof SmbComTransaction) {
                    response.command = request.command;
                    SmbComTransaction req = (SmbComTransaction)request;
                    SmbComTransactionResponse resp = (SmbComTransactionResponse)response;
                    req.maxBufferSize = this.snd_buf_size;
                    resp.reset();
                    try {
                        BufferCache.getBuffers(req, resp);
                        req.nextElement();
                        if (req.hasMoreElements()) {
                            SmbComBlankResponse interim = new SmbComBlankResponse();
                            super.sendrecv(req, interim, SmbConstants.RESPONSE_TIMEOUT);
                            if (interim.errorCode != 0) {
                                this.checkStatus(req, interim);
                            }
                            req.nextElement();
                        } else {
                            this.makeKey(req);
                        }
                        HashMap hashMap = this.response_map;
                        synchronized (hashMap) {
                            response.received = false;
                            resp.isReceived = false;
                            try {
                                this.response_map.put(req, resp);
                                do {
                                    this.doSend0(req);
                                } while (req.hasMoreElements() && req.nextElement() != null);
                                long timeout = SmbConstants.RESPONSE_TIMEOUT;
                                resp.expiration = System.currentTimeMillis() + timeout;
                                while (resp.hasMoreElements()) {
                                    this.response_map.wait(timeout);
                                    timeout = resp.expiration - System.currentTimeMillis();
                                    if (timeout > 0L) continue;
                                    throw new TransportException(this + " timedout waiting for response to " + req);
                                }
                                if (response.errorCode != 0) {
                                    this.checkStatus(req, resp);
                                }
                            }
                            catch (InterruptedException ie) {
                                throw new TransportException(ie);
                            }
                            finally {
                                this.response_map.remove(req);
                            }
                            break block24;
                        }
                    }
                    finally {
                        BufferCache.releaseBuffer(req.txn_buf);
                        BufferCache.releaseBuffer(resp.txn_buf);
                    }
                }
                response.command = request.command;
                super.sendrecv(request, response, SmbConstants.RESPONSE_TIMEOUT);
            }
            catch (SmbException se) {
                throw se;
            }
            catch (IOException ioe) {
                throw new SmbException("", (Throwable)ioe);
            }
        }
        this.checkStatus(request, response);
    }

    public String toString() {
        return super.toString() + "[" + this.address + ":" + this.port + "]";
    }

    DfsReferral getDfsReferral(NtlmPasswordAuthentication auth, String path) throws SmbException {
        int s;
        int p;
        int i;
        DfsReferral dr = new DfsReferral();
        SmbTree ipc = this.getSmbSession(auth).getSmbTree("IPC$", null);
        Trans2GetDfsReferralResponse resp = new Trans2GetDfsReferralResponse();
        ipc.send(new Trans2GetDfsReferral(path), resp);
        String subpath = path.substring(0, resp.pathConsumed);
        String node = resp.referral.node;
        if (subpath.charAt(0) != '\\' || (i = subpath.indexOf(92, 1)) < 2 || (p = subpath.indexOf(92, i + 1)) < i + 2 || node.charAt(0) != '\\' || (s = node.indexOf(92, 1)) < 2) {
            throw new SmbException("Invalid DFS path: " + path);
        }
        int n = node.indexOf(92, s + 1);
        if (n == -1) {
            n = node.length();
        }
        dr.path = subpath.substring(p);
        dr.node = node.substring(0, n);
        dr.nodepath = node.substring(n);
        dr.server = node.substring(1, s);
        dr.share = node.substring(s + 1, n);
        dr.resolveHashes = auth.hashesExternal;
        return dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DfsReferral lookupReferral(String unc) {
        LinkedList linkedList = this.referrals;
        synchronized (linkedList) {
            ListIterator iter = this.referrals.listIterator();
            while (iter.hasNext()) {
                int i;
                DfsReferral dr = (DfsReferral)iter.next();
                int len = dr.path.length();
                for (i = 0; i < len && i < unc.length() && dr.path.charAt(i) == unc.charAt(i); ++i) {
                }
                if (i != len || len != unc.length() && unc.charAt(len) != '\\') continue;
                return dr;
            }
        }
        return null;
    }

    class ServerData {
        byte flags;
        int flags2;
        int maxMpxCount;
        int maxBufferSize;
        int sessionKey;
        int capabilities;
        String oemDomainName;
        int securityMode;
        int security;
        boolean encryptedPasswords;
        boolean signaturesEnabled;
        boolean signaturesRequired;
        int maxNumberVcs;
        int maxRawSize;
        long serverTime;
        int serverTimeZone;
        int encryptionKeyLength;
        byte[] encryptionKey;

        ServerData() {
        }
    }
}

