/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.util;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MimeUtils {
    public static final String MIMETYPES_PROPERTIES = "mimeTypes.properties";
    private static Properties properties;

    public static String getFileMimeType(File file) {
        if (file == null) {
            return null;
        }
        return MimeUtils.getFileMimeType(file.getName());
    }

    public static String getFileMimeType(String fileName) {
        if (StringUtils.isBlank((String)fileName) || fileName.indexOf(".") == -1) {
            return null;
        }
        fileName = fileName.substring(fileName.lastIndexOf("."));
        return MimeUtils.getExtensionMimeType(fileName);
    }

    public static String getExtensionMimeType(String extension) {
        String result = null;
        if (StringUtils.isBlank((String)extension)) {
            return result;
        }
        MimeUtils.init();
        extension = extension.toLowerCase();
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        result = (String)properties.get(extension);
        return result;
    }

    private static void init() {
        if (properties != null) {
            return;
        }
        try {
            properties = new Properties();
            properties.load(new MimeUtils().getClass().getResourceAsStream(MIMETYPES_PROPERTIES));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        System.out.println("MimeUtils.getExtensionMimeType(.gif)=" + MimeUtils.getExtensionMimeType(".gif"));
        System.out.println("MimeUtils.getExtensionMimeType(.pdf)=" + MimeUtils.getExtensionMimeType(".pdf"));
        System.out.println("MimeUtils.getExtensionMimeType(.xls)=" + MimeUtils.getExtensionMimeType(".xls"));
        System.out.println("MimeUtils.getFileMimeType(foo.gif)=" + MimeUtils.getFileMimeType("foo.gif"));
        System.out.println("MimeUtils.getFileMimeType(foo.pdf)=" + MimeUtils.getFileMimeType("foo.pdf"));
        System.out.println("MimeUtils.getFileMimeType(foo.xls)=" + MimeUtils.getFileMimeType("foo.xls"));
        System.out.println("MimeUtils.getFileMimeType(foo.badextension)=" + MimeUtils.getFileMimeType("foo.badextension"));
    }
}

