/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.util.HtmlBuilder;

public class StatusBarBuilder {
    private HtmlBuilder html;
    private TableModel model;

    public StatusBarBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public StatusBarBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    public void statusMessage() {
        if (this.model.getLimit().getTotalRows() == 0) {
            this.html.append(this.model.getMessages().getMessage("statusbar.noResultsFound"));
        } else {
            Integer total = new Integer(this.model.getLimit().getTotalRows());
            Integer from = new Integer(this.model.getLimit().getRowStart() + 1);
            Integer to = new Integer(this.model.getLimit().getRowEnd());
            Object[] messageArguments = new Object[]{total, from, to};
            this.html.append(this.model.getMessages().getMessage("statusbar.resultsFound", messageArguments));
        }
    }

    public String toString() {
        return this.html.toString();
    }
}

