/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.util.HtmlBuilder;

public class ColumnBuilder {
    private HtmlBuilder html;
    private Column column;

    public ColumnBuilder(Column column) {
        this(new HtmlBuilder(), column);
    }

    public ColumnBuilder(HtmlBuilder html, Column column) {
        this.html = html;
        this.column = column;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected Column getColumn() {
        return this.column;
    }

    public void tdStart() {
        this.html.td(2);
        this.styleClass();
        this.style();
        this.width();
        this.html.close();
    }

    public void tdEnd() {
        this.html.tdEnd();
    }

    public void style() {
        String style = this.column.getStyle();
        this.html.style(style);
    }

    public void styleClass() {
        String styleClass = this.column.getStyleClass();
        this.html.styleClass(styleClass);
    }

    public void width() {
        String width = this.column.getWidth();
        this.html.width(width);
    }

    public void tdBody(String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.html.append(value);
        } else {
            this.html.nbsp();
        }
    }

    public String toString() {
        return this.html.toString();
    }
}

