/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.Registry;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.state.State;

public abstract class AbstractRegistry
implements Registry {
    protected Map parameterMap;
    protected Context context;
    protected String tableId;
    protected String prefixWithTableId;
    protected String state;
    protected String stateAttr;
    protected boolean autoIncludeParameters;

    public void setParameterMap() {
        HashMap<String, String[]> tableParameterMap = new HashMap<String, String[]>();
        HashMap<String, String[]> userDefinedParameterMap = new HashMap<String, String[]>();
        Map params = this.context.getParameterMap();
        Iterator iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String[] paramValues;
            String paramName = (String)iter.next();
            if (paramName.equals("ec_eti") || paramName.equals("ec_i")) continue;
            if (paramName.startsWith(this.prefixWithTableId + "p") || paramName.startsWith(this.prefixWithTableId + "crd") || paramName.startsWith(this.prefixWithTableId + "s_") || paramName.startsWith(this.prefixWithTableId + "f_") || paramName.startsWith(this.prefixWithTableId + "ev") || paramName.startsWith(this.prefixWithTableId + "efn") || paramName.startsWith(this.prefixWithTableId + "a_") || paramName.startsWith(this.prefixWithTableId + "o_")) {
                paramValues = TableModelUtils.getValueAsArray(params.get(paramName));
                tableParameterMap.put(paramName, paramValues);
                continue;
            }
            if (!this.autoIncludeParameters) continue;
            paramValues = TableModelUtils.getValueAsArray(params.get(paramName));
            userDefinedParameterMap.put(paramName, paramValues);
        }
        this.parameterMap = this.handleState(tableParameterMap);
        this.parameterMap.putAll(userDefinedParameterMap);
    }

    public Map handleState(Map tableParameterMap) {
        Map stateParameters;
        State state = TableCache.getInstance().getState(this.state);
        if (tableParameterMap.isEmpty() && (stateParameters = state.getParameters(this.context, this.tableId, this.stateAttr)) != null) {
            tableParameterMap = stateParameters;
        }
        this.handleStateInternal(state, tableParameterMap);
        return tableParameterMap;
    }

    public void addParameter(String name, Object value) {
        String[] paramValues = TableModelUtils.getValueAsArray(value);
        this.parameterMap.put(name, paramValues);
    }

    public String getParameter(String parameter) {
        String[] values = (String[])this.parameterMap.get(parameter);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameterMap;
    }

    public void removeParameter(String parameter) {
        this.parameterMap.remove(parameter);
    }

    protected abstract void handleStateInternal(State var1, Map var2);
}

