/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.callback;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.callback.FilterPredicate;
import org.extremecomponents.table.callback.FilterRowsCallback;
import org.extremecomponents.table.callback.NullSafeBeanComparator;
import org.extremecomponents.table.callback.RetrieveRowsCallback;
import org.extremecomponents.table.callback.SortRowsCallback;
import org.extremecomponents.table.core.RetrievalUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.limit.Sort;

public class ProcessRowsCallback
implements RetrieveRowsCallback,
FilterRowsCallback,
SortRowsCallback {
    private static Log logger = LogFactory.getLog((Class)(class$org$extremecomponents$table$callback$ProcessRowsCallback == null ? (class$org$extremecomponents$table$callback$ProcessRowsCallback = ProcessRowsCallback.class$("org.extremecomponents.table.callback.ProcessRowsCallback")) : class$org$extremecomponents$table$callback$ProcessRowsCallback));
    static /* synthetic */ Class class$org$extremecomponents$table$callback$ProcessRowsCallback;

    public Collection retrieveRows(TableModel model) throws Exception {
        Table table = model.getTableHandler().getTable();
        return RetrievalUtils.retrieveCollection(model.getContext(), table.getItems(), table.getScope());
    }

    public Collection filterRows(TableModel model, Collection rows) throws Exception {
        boolean filtered = model.getLimit().isFiltered();
        boolean cleared = model.getLimit().isCleared();
        if (!filtered || cleared) {
            return rows;
        }
        if (filtered) {
            ArrayList collection = new ArrayList();
            FilterPredicate filterPredicate = new FilterPredicate(model);
            CollectionUtils.select((Collection)rows, (Predicate)filterPredicate, collection);
            return collection;
        }
        return rows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection sortRows(TableModel model, Collection rows) throws Exception {
        boolean sorted = model.getLimit().isSorted();
        if (!sorted) {
            return rows;
        }
        Sort sort = model.getLimit().getSort();
        String property = sort.getProperty();
        String sortOrder = sort.getSortOrder();
        if (StringUtils.contains((String)property, (String)".")) {
            try {
                if (sortOrder.equals("asc")) {
                    Collections.sort((List)rows, new NullSafeBeanComparator(property, (Comparator)new NullComparator()));
                    return rows;
                }
                if (!sortOrder.equals("desc")) return rows;
                NullSafeBeanComparator reversedNaturalOrderBeanComparator = new NullSafeBeanComparator(property, (Comparator)new ReverseComparator((Comparator)new NullComparator()));
                Collections.sort((List)rows, reversedNaturalOrderBeanComparator);
                return rows;
            }
            catch (NoClassDefFoundError e) {
                String msg = "The column property [" + property + "] is nested and requires BeanUtils 1.7 or greater for proper sorting.";
                logger.error((Object)msg);
                throw new NoClassDefFoundError(msg);
            }
        } else if (sortOrder.equals("asc")) {
            BeanComparator comparator = new BeanComparator(property, (Comparator)new NullComparator());
            Collections.sort((List)rows, comparator);
            return rows;
        } else {
            if (!sortOrder.equals("desc")) return rows;
            BeanComparator reversedNaturalOrderBeanComparator = new BeanComparator(property, (Comparator)new ReverseComparator((Comparator)new NullComparator()));
            Collections.sort((List)rows, reversedNaturalOrderBeanComparator);
        }
        return rows;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

