/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.RrdException;
import org.jrobin.data.DataProcessor;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.ValueScaler;

class CommentText
implements RrdGraphConstants {
    private final String text;
    String resolvedText;
    String marker;
    boolean enabled;
    int x;
    int y;

    CommentText(String text) {
        this.text = text;
    }

    void resolveText(DataProcessor dproc, ValueScaler valueScaler) throws RrdException {
        this.resolvedText = this.text;
        this.marker = "";
        if (this.resolvedText != null) {
            for (String mark : MARKERS) {
                if (!this.resolvedText.endsWith(mark)) continue;
                this.marker = mark;
                this.resolvedText = this.resolvedText.substring(0, this.resolvedText.length() - this.marker.length());
                this.trimIfGlue();
                break;
            }
        }
        this.enabled = this.resolvedText != null;
    }

    void trimIfGlue() {
        if (this.marker.equals("\\g")) {
            this.resolvedText = this.resolvedText.trim();
        }
    }

    boolean isPrint() {
        return false;
    }

    boolean isValidGraphElement() {
        return !this.isPrint() && this.enabled;
    }
}

