/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.util.ArrayList;
import java.util.Arrays;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.Util;
import org.jrobin.data.Aggregates;

class Aggregator
implements ConsolFuns {
    private long[] timestamps;
    private long step;
    private double[] values;

    Aggregator(long[] timestamps, double[] values) {
        assert (timestamps.length == values.length) : "Incompatible timestamps/values arrays (unequal lengths)";
        assert (timestamps.length >= 2) : "At least two timestamps must be supplied";
        this.timestamps = timestamps;
        this.values = values;
        this.step = timestamps[1] - timestamps[0];
    }

    Aggregates getAggregates(long tStart, long tEnd) {
        Aggregates agg = new Aggregates();
        long totalSeconds = 0L;
        boolean firstFound = false;
        for (int i = 0; i < this.timestamps.length; ++i) {
            long left = Math.max(this.timestamps[i] - this.step, tStart);
            long right = Math.min(this.timestamps[i], tEnd);
            long delta = right - left;
            if (delta <= 0L) continue;
            double value = this.values[i];
            agg.min = Util.min(agg.min, value);
            agg.max = Util.max(agg.max, value);
            if (!firstFound) {
                agg.first = value;
                firstFound = true;
            }
            agg.last = value;
            if (Double.isNaN(value)) continue;
            agg.total = Util.sum(agg.total, (double)delta * value);
            totalSeconds += delta;
        }
        agg.average = totalSeconds > 0L ? agg.total / (double)totalSeconds : Double.NaN;
        return agg;
    }

    double getPercentile(long tStart, long tEnd, double percentile) {
        ArrayList<Double> valueList = new ArrayList<Double>();
        for (int i = 0; i < this.timestamps.length; ++i) {
            long left = Math.max(this.timestamps[i] - this.step, tStart);
            long right = Math.min(this.timestamps[i], tEnd);
            if (right <= left || Double.isNaN(this.values[i])) continue;
            valueList.add(this.values[i]);
        }
        int count = valueList.size();
        if (count > 1) {
            double[] valuesCopy = new double[count];
            for (int i = 0; i < count; ++i) {
                valuesCopy[i] = (Double)valueList.get(i);
            }
            Arrays.sort(valuesCopy);
            double topPercentile = (100.0 - percentile) / 100.0;
            count -= (int)Math.ceil((double)count * topPercentile);
            if (count > 0) {
                return valuesCopy[count - 1];
            }
        }
        return Double.NaN;
    }
}

