/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.jrobin.core.RrdFileBackend;
import sun.nio.ch.DirectBuffer;

public class RrdNioBackend
extends RrdFileBackend {
    private static final Timer fileSyncTimer = new Timer(true);
    private MappedByteBuffer byteBuffer;
    private TimerTask syncTask = new TimerTask(){

        public void run() {
            RrdNioBackend.this.sync();
        }
    };

    protected RrdNioBackend(String path, boolean readOnly, int syncPeriod) throws IOException {
        super(path, readOnly);
        try {
            this.mapFile();
            if (!readOnly) {
                fileSyncTimer.schedule(this.syncTask, (long)syncPeriod * 1000L, (long)syncPeriod * 1000L);
            }
        }
        catch (IOException ioe) {
            super.close();
            throw ioe;
        }
    }

    private void mapFile() throws IOException {
        long length = this.getLength();
        if (length > 0L) {
            FileChannel.MapMode mapMode = this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.byteBuffer = this.file.getChannel().map(mapMode, 0L, length);
        }
    }

    private void unmapFile() {
        if (this.byteBuffer != null) {
            if (this.byteBuffer instanceof DirectBuffer) {
                ((DirectBuffer)((Object)this.byteBuffer)).cleaner().clean();
            }
            this.byteBuffer = null;
        }
    }

    protected synchronized void setLength(long newLength) throws IOException {
        this.unmapFile();
        super.setLength(newLength);
        this.mapFile();
    }

    protected synchronized void write(long offset, byte[] b) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.put(b);
    }

    protected synchronized void read(long offset, byte[] b) throws IOException {
        if (this.byteBuffer == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.byteBuffer.position((int)offset);
        this.byteBuffer.get(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            if (this.syncTask != null) {
                this.syncTask.cancel();
            }
            this.sync();
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.byteBuffer != null) {
            this.byteBuffer.force();
        }
    }
}

