/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import org.jrobin.core.ConsolFuns;
import org.jrobin.core.RrdException;

public class ArcDef
implements ConsolFuns {
    public static final String[] CONSOL_FUNS = new String[]{"AVERAGE", "MAX", "MIN", "LAST"};
    private String consolFun;
    private double xff;
    private int steps;
    private int rows;

    public ArcDef(String consolFun, double xff, int steps, int rows) throws RrdException {
        this.consolFun = consolFun;
        this.xff = xff;
        this.steps = steps;
        this.rows = rows;
        this.validate();
    }

    public String getConsolFun() {
        return this.consolFun;
    }

    public double getXff() {
        return this.xff;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getRows() {
        return this.rows;
    }

    private void validate() throws RrdException {
        if (!ArcDef.isValidConsolFun(this.consolFun)) {
            throw new RrdException("Invalid consolidation function specified: " + this.consolFun);
        }
        if (Double.isNaN(this.xff) || this.xff < 0.0 || this.xff >= 1.0) {
            throw new RrdException("Invalid xff, must be >= 0 and < 1: " + this.xff);
        }
        if (this.steps < 1 || this.rows < 2) {
            throw new RrdException("Invalid steps/rows settings: " + this.steps + "/" + this.rows + ". Minimal values allowed are steps=1, rows=2");
        }
    }

    public String dump() {
        return "RRA:" + this.consolFun + ":" + this.xff + ":" + this.steps + ":" + this.rows;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArcDef) {
            ArcDef arcObj = (ArcDef)obj;
            return this.consolFun.equals(arcObj.consolFun) && this.steps == arcObj.steps;
        }
        return false;
    }

    public static boolean isValidConsolFun(String consolFun) {
        for (String cFun : CONSOL_FUNS) {
            if (!cFun.equals(consolFun)) continue;
            return true;
        }
        return false;
    }

    void setRows(int rows) {
        this.rows = rows;
    }

    boolean exactlyEqual(ArcDef def) {
        return this.consolFun.equals(def.consolFun) && this.xff == def.xff && this.steps == def.steps && this.rows == def.rows;
    }
}

