/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.cmd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.jrobin.cmd.RrdCreateCmd;
import org.jrobin.cmd.RrdDumpCmd;
import org.jrobin.cmd.RrdFetchCmd;
import org.jrobin.cmd.RrdGraphCmd;
import org.jrobin.cmd.RrdInfoCmd;
import org.jrobin.cmd.RrdLastCmd;
import org.jrobin.cmd.RrdRestoreCmd;
import org.jrobin.cmd.RrdToolCmd;
import org.jrobin.cmd.RrdTuneCmd;
import org.jrobin.cmd.RrdUpdateCmd;
import org.jrobin.cmd.RrdXportCmd;
import org.jrobin.core.RrdException;

public class RrdCommander {
    private static final RrdToolCmd[] rrdCommands = new RrdToolCmd[]{new RrdCreateCmd(), new RrdUpdateCmd(), new RrdLastCmd(), new RrdFetchCmd(), new RrdDumpCmd(), new RrdRestoreCmd(), new RrdXportCmd(), new RrdGraphCmd(), new RrdTuneCmd(), new RrdInfoCmd()};

    public static synchronized boolean isStandardOutUsed() {
        return RrdToolCmd.isStandardOutUsed();
    }

    public static synchronized void setStandardOutUsed(boolean standardOutUsed) {
        RrdToolCmd.setStandardOutUsed(standardOutUsed);
    }

    public static synchronized boolean isRrdDbPoolUsed() {
        return RrdToolCmd.isRrdDbPoolUsed();
    }

    public static synchronized void setRrdDbPoolUsed(boolean rrdDbPoolUsed) {
        RrdToolCmd.setRrdDbPoolUsed(rrdDbPoolUsed);
    }

    public static synchronized Object execute(String command) throws IOException, RrdException {
        String rrdtool;
        String cmd = command.trim();
        if (cmd.startsWith(rrdtool = "rrdtool ")) {
            cmd = cmd.substring(rrdtool.length());
        }
        for (RrdToolCmd rrdCommand : rrdCommands) {
            if (!cmd.startsWith(rrdCommand.getCmdType() + " ")) continue;
            return rrdCommand.executeCommand(cmd);
        }
        throw new RrdException("Unknown RRDTool command: " + command);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("== JRobin's RRDTool commander ==");
        System.out.println("Type a RRDTool command after the dollar sign and press Enter.");
        System.out.println("Start your RRDTool command with 'create', 'update', 'fetch' etc.");
        System.out.println("Start line with 'create', 'update', 'fetch' etc.");
        System.out.println("Enter dot ('.') to bail out");
        System.out.println("Current directory is: " + new File(".").getCanonicalPath());
        System.out.println("================================");
        RrdToolCmd.setRrdDbPoolUsed(false);
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print("$ ");
                    String s = r.readLine().trim();
                    if (s.length() <= 0) continue;
                    if (s.startsWith(".")) break block2;
                    RrdCommander.execute(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }
}

