/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CollectionMath {
    public static long countNull(List list) {
        long count = 0L;
        for (Object entry : list) {
            if (entry != null) continue;
            ++count;
        }
        return count;
    }

    public static long countNotNull(List list) {
        return (long)list.size() - CollectionMath.countNull(list);
    }

    public static Number percentNull(List<Number> list) {
        return CollectionMath.percentNull(CollectionMath.convertNumberToBigDecimal(list));
    }

    public static BigDecimal percentNull(List<BigDecimal> list) {
        if (list.size() > 0) {
            return new BigDecimal(CollectionMath.countNull(list)).divide(new BigDecimal(list.size()), 16, 6).multiply(new BigDecimal(100));
        }
        return null;
    }

    public static Number percentNotNull(List<Number> list) {
        return CollectionMath.percentNotNull(CollectionMath.convertNumberToBigDecimal(list));
    }

    public static BigDecimal percentNotNull(List<BigDecimal> list) {
        if (list.size() > 0) {
            return new BigDecimal(CollectionMath.countNotNull(list)).divide(new BigDecimal(list.size()), 16, 6).multiply(new BigDecimal(100));
        }
        return null;
    }

    public static Number average(List<Number> list) {
        return CollectionMath.average(CollectionMath.convertNumberToBigDecimal(list));
    }

    public static BigDecimal average(List<BigDecimal> list) {
        BigDecimal total = new BigDecimal(0);
        List<BigDecimal> notNullEntries = CollectionMath.getNotNullEntries(list);
        if (notNullEntries.size() == 0) {
            return null;
        }
        for (BigDecimal entry : notNullEntries) {
            total = total.add(entry);
        }
        return total.divide(new BigDecimal(notNullEntries.size()), 16, 6);
    }

    public static Number median(List<Number> list) {
        return CollectionMath.median(CollectionMath.convertNumberToBigDecimal(list));
    }

    public static BigDecimal median(List<BigDecimal> list) {
        List<BigDecimal> notNullEntries = CollectionMath.getNotNullEntries(list);
        Collections.sort(notNullEntries);
        if (notNullEntries.size() == 0) {
            return null;
        }
        if (notNullEntries.size() % 2 == 0) {
            BigDecimal value1 = notNullEntries.get(notNullEntries.size() / 2);
            BigDecimal value2 = notNullEntries.get(notNullEntries.size() / 2 - 1);
            return value1.add(value2).divide(new BigDecimal(2), 16, 6);
        }
        return notNullEntries.get(notNullEntries.size() / 2);
    }

    private static List<BigDecimal> convertNumberToBigDecimal(List<Number> c) {
        ArrayList<BigDecimal> bd = new ArrayList<BigDecimal>();
        for (Number entry : c) {
            if (entry == null) continue;
            bd.add(new BigDecimal(entry.doubleValue()));
        }
        return bd;
    }

    private static List<BigDecimal> getNotNullEntries(List<BigDecimal> list) {
        ArrayList<BigDecimal> s = new ArrayList<BigDecimal>();
        for (BigDecimal entry : list) {
            if (entry == null) continue;
            s.add(entry);
        }
        return s;
    }
}

