/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.rule.PackageCompilationData;

public class CompositePackageClassLoader
extends ClassLoader {
    private final List classLoaders = new ArrayList();

    public CompositePackageClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void removeClassLoader(ClassLoader classLoader) {
        Iterator iterator = this.classLoaders.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != classLoader) continue;
            iterator.remove();
            break;
        }
    }

    private Class compositeFastFindClass(String string) {
        Iterator iterator = this.classLoaders.iterator();
        while (iterator.hasNext()) {
            PackageCompilationData.PackageClassLoader packageClassLoader = (PackageCompilationData.PackageClassLoader)iterator.next();
            Class clazz = packageClassLoader.fastFindClass(string);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null && (clazz = this.compositeFastFindClass(string)) == null) {
            ClassLoader classLoader = this.getParent();
            if (classLoader != null) {
                clazz = classLoader.loadClass(string);
            } else {
                throw new ClassNotFoundException(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        Class clazz = this.compositeFastFindClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }
}

