/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.common.ActivationGroupImpl;
import org.drools.common.ActivationGroupNode;
import org.drools.common.AgendaGroupImpl;
import org.drools.common.AgendaItem;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgenda;
import org.drools.common.ScheduledAgendaItem;
import org.drools.common.Scheduler;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AgendaGroup;
import org.drools.spi.ConsequenceException;
import org.drools.spi.KnowledgeHelper;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListNode;
import org.drools.util.Queueable;

public class DefaultAgenda
implements Serializable,
InternalAgenda {
    private static final long serialVersionUID = -9112292414291983688L;
    private final WorkingMemory workingMemory;
    private LinkedList scheduledActivations;
    private final Map agendaGroups;
    private final Map activationGroups;
    private final java.util.LinkedList focusStack;
    private AgendaGroupImpl currentModule;
    private AgendaGroup main;

    public DefaultAgenda(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.agendaGroups = new HashMap();
        this.activationGroups = new HashMap();
        this.focusStack = new java.util.LinkedList();
        this.main = new AgendaGroupImpl("MAIN");
        this.agendaGroups.put("MAIN", this.main);
        this.focusStack.add(this.main);
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void scheduleItem(ScheduledAgendaItem scheduledAgendaItem) {
        Scheduler.getInstance().scheduleAgendaItem(scheduledAgendaItem);
        if (this.scheduledActivations == null) {
            this.scheduledActivations = new LinkedList();
        }
        this.scheduledActivations.add(scheduledAgendaItem);
    }

    public void removeScheduleItem(ScheduledAgendaItem scheduledAgendaItem) {
        this.scheduledActivations.remove(scheduledAgendaItem);
        scheduledAgendaItem.cancel();
    }

    public LinkedList getScheduledItems() {
        return this.scheduledActivations;
    }

    public void addAgendaGroup(AgendaGroup agendaGroup) {
        this.agendaGroups.put(agendaGroup.getName(), agendaGroup);
    }

    public boolean setFocus(AgendaGroup agendaGroup) {
        if (this.focusStack.getLast() != agendaGroup) {
            this.focusStack.add(agendaGroup);
            return true;
        }
        return false;
    }

    public void setFocus(String string) {
        AgendaGroup agendaGroup = (AgendaGroup)this.agendaGroups.get(string);
        if (agendaGroup == null) {
            agendaGroup = new AgendaGroupImpl(string);
            ((DefaultAgenda)this.workingMemory.getAgenda()).addAgendaGroup(agendaGroup);
        }
        this.setFocus(agendaGroup);
    }

    public AgendaGroup getFocus() {
        return (AgendaGroup)this.focusStack.getLast();
    }

    public AgendaGroup getNextFocus() {
        boolean bl;
        AgendaGroupImpl agendaGroupImpl = null;
        while ((bl = (agendaGroupImpl = (AgendaGroupImpl)this.focusStack.getLast()).isEmpty()) && this.focusStack.size() > 1) {
            this.focusStack.removeLast();
        }
        agendaGroupImpl = bl ? null : agendaGroupImpl;
        return agendaGroupImpl;
    }

    public void setCurrentAgendaGroup(AgendaGroup agendaGroup) {
        this.currentModule = (AgendaGroupImpl)agendaGroup;
    }

    public AgendaGroup getCurrentAgendaGroup() {
        return this.currentModule;
    }

    public AgendaGroup getAgendaGroup(String string) {
        return (AgendaGroup)this.agendaGroups.get(string);
    }

    public AgendaGroup[] getAgendaGroups() {
        return this.agendaGroups.values().toArray(new AgendaGroup[this.agendaGroups.size()]);
    }

    public AgendaGroup[] getStack() {
        return this.focusStack.toArray(new AgendaGroup[this.focusStack.size()]);
    }

    public ActivationGroup getActivationGroup(String string) {
        ActivationGroupImpl activationGroupImpl = (ActivationGroupImpl)this.activationGroups.get(string);
        if (activationGroupImpl == null) {
            activationGroupImpl = new ActivationGroupImpl(string);
            this.activationGroups.put(string, activationGroupImpl);
        }
        return activationGroupImpl;
    }

    public int focusStackSize() {
        int n = 0;
        Iterator iterator = this.focusStack.iterator();
        while (iterator.hasNext()) {
            AgendaGroupImpl agendaGroupImpl = (AgendaGroupImpl)iterator.next();
            n += agendaGroupImpl.size();
        }
        return n;
    }

    public int agendaSize() {
        int n = 0;
        Iterator iterator = this.agendaGroups.values().iterator();
        while (iterator.hasNext()) {
            AgendaGroupImpl agendaGroupImpl = (AgendaGroupImpl)iterator.next();
            n += agendaGroupImpl.size();
        }
        return n;
    }

    public Activation[] getActivations() {
        ArrayList<Activation> arrayList = new ArrayList<Activation>();
        Iterator iterator = this.agendaGroups.values().iterator();
        while (iterator.hasNext()) {
            AgendaGroup agendaGroup = (AgendaGroup)iterator.next();
            arrayList.addAll(Arrays.asList(agendaGroup.getActivations()));
        }
        return arrayList.toArray(new Activation[arrayList.size()]);
    }

    public Activation[] getScheduledActivations() {
        ArrayList<LinkedListNode> arrayList = new ArrayList<LinkedListNode>(this.scheduledActivations.size());
        for (LinkedListNode linkedListNode = this.scheduledActivations.getFirst(); linkedListNode != null; linkedListNode = linkedListNode.getNext()) {
            arrayList.add(linkedListNode);
        }
        return arrayList.toArray(new Activation[arrayList.size()]);
    }

    public void clearAgenda() {
        Serializable serializable;
        Object object = this.agendaGroups.values().iterator();
        while (object.hasNext()) {
            serializable = (AgendaGroupImpl)object.next();
            this.clearAgendaGroup((AgendaGroup)serializable);
        }
        object = (EventSupport)((Object)this.workingMemory);
        if (this.scheduledActivations != null && !this.scheduledActivations.isEmpty()) {
            serializable = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            while (serializable != null) {
                ((ScheduledAgendaItem)serializable).remove();
                object.getAgendaEventSupport().fireActivationCancelled((Activation)((Object)serializable));
                serializable = (ScheduledAgendaItem)this.scheduledActivations.removeFirst();
            }
        }
    }

    public void clearAgendaGroup(String string) {
        AgendaGroupImpl agendaGroupImpl = (AgendaGroupImpl)this.agendaGroups.get(string);
        if (agendaGroupImpl != null) {
            this.clearAgendaGroup(agendaGroupImpl);
        }
    }

    public void clearAgendaGroup(AgendaGroup agendaGroup) {
        EventSupport eventSupport = (EventSupport)((Object)this.workingMemory);
        Queueable[] queueableArray = ((AgendaGroupImpl)agendaGroup).getQueueable();
        int n = queueableArray.length;
        for (int i = 0; i < n; ++i) {
            AgendaItem agendaItem = (AgendaItem)queueableArray[i];
            if (agendaItem == null) continue;
            agendaItem.setActivated(false);
            if (agendaItem.getActivationGroupNode() != null) {
                agendaItem.getActivationGroupNode().getActivationGroup().removeActivation(agendaItem);
            }
            eventSupport.getAgendaEventSupport().fireActivationCancelled(agendaItem);
        }
        ((AgendaGroupImpl)agendaGroup).clear();
    }

    public void clearActivationGroup(String string) {
        ActivationGroup activationGroup = (ActivationGroup)this.activationGroups.get(string);
        if (activationGroup != null) {
            this.clearActivationGroup(activationGroup);
        }
    }

    public void clearActivationGroup(ActivationGroup activationGroup) {
        EventSupport eventSupport = (EventSupport)((Object)this.workingMemory);
        Iterator iterator = activationGroup.iterator();
        while (iterator.hasNext()) {
            Activation activation = ((ActivationGroupNode)iterator.next()).getActivation();
            activation.setActivationGroupNode(null);
            if (!activation.isActivated()) continue;
            activation.setActivated(false);
            activation.remove();
            eventSupport.getAgendaEventSupport().fireActivationCancelled(activation);
        }
        activationGroup.clear();
    }

    public boolean fireNextItem(AgendaFilter agendaFilter) throws ConsequenceException {
        AgendaGroupImpl agendaGroupImpl = (AgendaGroupImpl)this.getNextFocus();
        if (agendaGroupImpl == null) {
            return false;
        }
        AgendaItem agendaItem = (AgendaItem)agendaGroupImpl.getNext();
        if (agendaItem == null) {
            return false;
        }
        if (agendaFilter == null || agendaFilter.accept(agendaItem)) {
            this.fireActivation(agendaItem);
        }
        return true;
    }

    public synchronized void fireActivation(Activation activation) throws ConsequenceException {
        Object object;
        EventSupport eventSupport = (EventSupport)((Object)this.workingMemory);
        eventSupport.getAgendaEventSupport().fireBeforeActivationFired(activation);
        if (activation.getActivationGroupNode() != null) {
            object = activation.getActivationGroupNode().getActivationGroup();
            object.removeActivation(activation);
            this.clearActivationGroup((ActivationGroup)object);
        }
        activation.setActivated(false);
        try {
            object = new DefaultKnowledgeHelper(activation, this.workingMemory);
            activation.getRule().getConsequence().evaluate((KnowledgeHelper)object, this.workingMemory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConsequenceException(exception, activation.getRule());
        }
        eventSupport.getAgendaEventSupport().fireAfterActivationFired(activation);
    }
}

