/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.OneStepIteratorForward;

public class KeyIterator
extends OneStepIteratorForward {
    private QName m_name;
    private Vector m_keyDeclarations;

    public QName getName() {
        return this.m_name;
    }

    public Vector getKeyDeclarations() {
        return this.m_keyDeclarations;
    }

    KeyIterator(QName name, Vector keyDeclarations) {
        super(16);
        this.m_keyDeclarations = keyDeclarations;
        this.m_name = name;
    }

    public short acceptNode(int testNode) {
        boolean foundKey = false;
        KeyIterator ki = (KeyIterator)this.m_lpi;
        XPathContext xctxt = ki.getXPathContext();
        Vector keys = ki.getKeyDeclarations();
        QName name = ki.getName();
        try {
            int nDeclarations = keys.size();
            int i = 0;
            while (i < nDeclarations) {
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i);
                if (kd.getName().equals(name)) {
                    foundKey = true;
                    XPath matchExpr = kd.getMatch();
                    double score = matchExpr.getMatchScore(xctxt, testNode);
                    kd.getMatch();
                    if (score != Double.NEGATIVE_INFINITY) {
                        return 1;
                    }
                }
                ++i;
            }
        }
        catch (TransformerException se) {
            // empty catch block
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage(58, new Object[]{name.getLocalName()}));
        }
        return 2;
    }
}

