/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.poller.Downtime;
import org.opennms.netmgt.config.poller.Filter;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xmlrpcd.Provisioner;

public class OpenNMSProvisioner
implements Provisioner {
    private static final String JDBC_MONITOR = "org.opennms.netmgt.poller.monitors.JDBCMonitor";
    private static final String HTTPS_MONITOR = "org.opennms.netmgt.poller.monitors.HttpsMonitor";
    private static final String HTTP_MONITOR = "org.opennms.netmgt.poller.monitors.HttpMonitor";
    private static final String TCP_MONITOR = "org.opennms.netmgt.poller.monitors.TcpMonitor";
    private static final String DNS_MONITOR = "org.opennms.netmgt.poller.monitors.DnsMonitor";
    private static final String ICMP_MONITOR = "org.opennms.netmgt.poller.monitors.IcmpMonitor";
    private static final String JDBC_PLUGIN = "org.opennms.netmgt.capsd.plugins.JDBCPlugin";
    private static final String HTTPS_PLUGIN = "org.opennms.netmgt.capsd.plugins.HttpsPlugin";
    private static final String HTTP_PLUGIN = "org.opennms.netmgt.capsd.plugins.HttpPlugin";
    private static final String TCP_PLUGIN = "org.opennms.netmgt.capsd.plugins.TcpPlugin";
    private static final String DNS_PLUGIN = "org.opennms.netmgt.capsd.plugins.DnsPlugin";
    private static final String ICMP_PLUGIN = "org.opennms.netmgt.capsd.plugins.IcmpPlugin";
    private CapsdConfig m_capsdConfig;
    private PollerConfig m_pollerConfig;
    private EventIpcManager m_eventManager;
    private CapsdDbSyncer m_capsdDbSyncer;

    private void checkRetries(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("Illegal retries " + retries + ". Must be >= 0");
        }
    }

    private void checkTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Illegal timeout " + timeout + ". Must be > 0");
        }
    }

    private void checkInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Illegal interval " + interval + ". Must be > 0");
        }
    }

    private void checkDowntimeInterval(int interval) {
        this.checkInterval(interval);
    }

    private void checkDowntimeDuration(int duration) {
        this.checkInterval(duration);
    }

    private void checkPort(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Illegal port " + port + ". Must be between 1 and 65535 (inclusive)");
        }
    }

    private void checkHostname(String hostname) {
        if (hostname == null) {
            throw new NullPointerException("hostname must not be null");
        }
        if (hostname.length() > 512) {
            throw new IllegalArgumentException("Illegal hostname " + hostname + ". Hostnames must not be longer than 512 characters");
        }
    }

    private void checkUrl(String url) {
        if (url == null) {
            throw new NullPointerException("url must not be null");
        }
        if (url.length() == 0) {
            throw new IllegalArgumentException("Illegal url ''.  Must not be zero length");
        }
        if (url.length() > 512) {
            throw new IllegalArgumentException("Illegal url " + url + ". Must be less than 512 chars");
        }
    }

    private void checkContentCheck(String check) {
        if (check != null && check.length() > 128) {
            throw new IllegalArgumentException("Illegal contentCheck " + check + ". Must be less than 128 chars.");
        }
    }

    private void checkResponseRange(String response) {
        if (response == null || response.equals("")) {
            return;
        }
        if (response.indexOf(45) < 0) {
            this.checkResponseCode(response);
        } else {
            int dash = response.indexOf(45);
            String startCode = response.substring(0, dash).trim();
            if ("".equals(startCode)) {
                throw new IllegalArgumentException("Illegal Start code. Expected range format is <startCode>-<endCode>.");
            }
            this.checkResponseCode(startCode);
            if (dash + 1 > response.length() - 1) {
                throw new IllegalArgumentException("Illegal End code. Expected range format is <startcode>-<endcode>");
            }
            String endCode = response.substring(dash + 1);
            this.checkResponseCode(endCode);
        }
    }

    private void checkResponseCode(String response) {
        if (response == null || response.equals("")) {
            return;
        }
        int code = Integer.parseInt(response);
        if (code < 100 || code > 599) {
            throw new IllegalArgumentException("Illegal response code " + code + ". Must be between 100 and 599");
        }
    }

    private void checkUsername(String username) {
        if (username == null) {
            throw new NullPointerException("username is null");
        }
        if (username.length() > 64) {
            throw new IllegalArgumentException("Illegal username " + username + ". username must be less than 64 characters");
        }
    }

    private void checkPassword(String pw) {
        if (pw == null) {
            throw new NullPointerException("password is null");
        }
        if (pw.length() > 64) {
            throw new IllegalArgumentException("Illegal password " + pw + ". password must be less than 64 charachters");
        }
    }

    private void checkDriver(String driver) {
        if (driver == null) {
            throw new NullPointerException("driver is null");
        }
        if (driver.length() == 0) {
            throw new IllegalArgumentException("Illegal driver.  Must not be zero length");
        }
        if (driver.length() > 128) {
            throw new IllegalArgumentException("Illegal driver " + driver + ". Driver length must be less than 128 characters");
        }
    }

    private void validateSchedule(int retries, int timeout, int interval, int downTimeInterval, int downTimeDuration) {
        this.checkRetries(retries);
        this.checkTimeout(timeout);
        this.checkInterval(interval);
        this.checkDowntimeInterval(downTimeInterval);
        this.checkDowntimeDuration(downTimeDuration);
    }

    public boolean addServiceICMP(String serviceId, int retry, int timeout, int interval, int downTimeInterval, int downTimeDuration) {
        this.validateSchedule(retry, timeout, interval, downTimeInterval, downTimeDuration);
        return this.addService(serviceId, retry, timeout, interval, downTimeInterval, downTimeDuration, ICMP_MONITOR, ICMP_PLUGIN);
    }

    private boolean addService(String serviceId, int retries, int timeout, int interval, int downTimeInterval, int downTimeDuration, String monitor, String plugin) {
        return this.addService(serviceId, retries, timeout, interval, downTimeInterval, downTimeDuration, monitor, plugin, new Parm[0]);
    }

    private boolean addService(String serviceId, int retries, int timeout, int interval, int downTimeInterval, int downTimeDuration, String monitor, String plugin, Parm[] entries) {
        String pkgName = serviceId;
        Package pkg = this.getPackage(pkgName, interval, downTimeInterval, downTimeDuration);
        Properties parms = new Properties();
        parms.setProperty("retry", "" + retries);
        parms.setProperty("timeout", "" + timeout);
        for (int i = 0; i < entries.length; ++i) {
            parms.setProperty(entries[i].getKey(), entries[i].getVal());
        }
        this.addServiceToPackage(pkg, serviceId, interval, parms);
        if (this.m_pollerConfig.getPackage(pkg.getName()) == null) {
            this.m_pollerConfig.addPackage(pkg);
        }
        if (this.m_pollerConfig.getServiceMonitor(serviceId) == null) {
            this.log().debug((Object)("Adding a new monitor for " + serviceId));
            this.m_pollerConfig.addMonitor(serviceId, monitor);
        } else {
            this.log().debug((Object)("No need to add a new monitor for " + serviceId));
        }
        if (this.m_capsdConfig.getProtocolPlugin(serviceId) == null) {
            ProtocolPlugin pPlugin = new ProtocolPlugin();
            pPlugin.setProtocol(serviceId);
            pPlugin.setClassName(plugin);
            pPlugin.setScan("off");
            this.m_capsdConfig.addProtocolPlugin(pPlugin);
        }
        this.saveConfigs();
        return true;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void saveConfigs() {
        try {
            this.m_capsdConfig.save();
            this.syncServices();
            this.m_pollerConfig.save();
            Event event = new Event();
            event.setUei("uei.opennms.org/internal/schedOutagesChanged");
            event.setCreationTime(EventConstants.formatToString(new Date()));
            event.setTime(EventConstants.formatToString(new Date()));
            event.setSource("OpenNMSProvisioner");
            this.m_eventManager.sendNow(event);
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving poller or capsd configuration: " + e, e);
        }
    }

    private void syncServices() {
        this.getCapsdDbSyncer().syncServicesTable();
    }

    private void addServiceToPackage(Package pkg, String serviceId, int interval, Properties parms) {
        Service svc = this.m_pollerConfig.getServiceInPackage(serviceId, pkg);
        if (svc == null) {
            svc = new Service();
            svc.setName(serviceId);
            pkg.addService(svc);
        }
        svc.setInterval((long)interval);
        Enumeration<?> keys = parms.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = parms.getProperty(key);
            this.setParameter(svc, key, value);
        }
    }

    private void setParameter(Service svc, String key, String value) {
        Parameter parm = this.findParamterWithKey(svc, key);
        if (parm == null) {
            parm = new Parameter();
            svc.addParameter(parm);
        }
        parm.setKey(key);
        parm.setValue(value);
    }

    public Parameter findParamterWithKey(Service svc, String key) {
        Enumeration e = svc.enumerateParameter();
        while (e.hasMoreElements()) {
            Parameter parameter = (Parameter)e.nextElement();
            if (!key.equals(parameter.getKey())) continue;
            return parameter;
        }
        return null;
    }

    private Package getPackage(String pkgName, int interval, int downTimeInterval, int downTimeDuration) {
        Package pkg = this.m_pollerConfig.getPackage(pkgName);
        if (pkg == null) {
            pkg = new Package();
            pkg.setName(pkgName);
            Filter filter = new Filter();
            filter.setContent("IPADDR IPLIKE *.*.*.*");
            pkg.setFilter(filter);
            Rrd rrd = new Rrd();
            rrd.setStep(300);
            rrd.addRra("RRA:AVERAGE:0.5:1:2016");
            rrd.addRra("RRA:AVERAGE:0.5:12:4464");
            rrd.addRra("RRA:MIN:0.5:12:4464");
            rrd.addRra("RRA:MAX:0.5:12:4464");
            pkg.setRrd(rrd);
        }
        Downtime dt = new Downtime();
        dt.setBegin(0L);
        dt.setEnd((long)downTimeDuration);
        dt.setInterval((long)downTimeInterval);
        Downtime dt2 = new Downtime();
        dt2.setBegin((long)downTimeDuration);
        dt2.setInterval((long)interval);
        pkg.setDowntime(new Downtime[]{dt, dt2});
        return pkg;
    }

    public boolean addServiceDNS(String serviceId, int retry, int timeout, int interval, int downTimeInterval, int downTimeDuration, int port, String lookup) {
        this.validateSchedule(retry, timeout, interval, downTimeInterval, downTimeDuration);
        this.checkPort(port);
        this.checkHostname(lookup);
        Parm[] parm = new Parm[]{new Parm("port", port), new Parm("lookup", lookup)};
        return this.addService(serviceId, retry, timeout, interval, downTimeInterval, downTimeDuration, DNS_MONITOR, DNS_PLUGIN, parm);
    }

    public boolean addServiceTCP(String serviceId, int retry, int timeout, int interval, int downTimeInterval, int downTimeDuration, int port, String banner) {
        this.validateSchedule(retry, timeout, interval, downTimeInterval, downTimeDuration);
        this.checkPort(port);
        this.checkContentCheck(banner);
        Parm[] parm = new Parm[]{new Parm("port", port), new Parm("banner", banner)};
        return this.addService(serviceId, retry, timeout, interval, downTimeInterval, downTimeDuration, TCP_MONITOR, TCP_PLUGIN, parm);
    }

    public boolean addServiceHTTP(String serviceId, int retry, int timeout, int interval, int downTimeInterval, int downTimeDuration, String hostName, int port, String response, String responseText, String url, String user, String passwd, String agent) throws MalformedURLException {
        this.validateSchedule(retry, timeout, interval, downTimeInterval, downTimeDuration);
        this.checkHostname(hostName);
        this.checkUsername(user);
        this.checkPassword(passwd);
        this.checkPort(port);
        this.checkResponseRange(response);
        this.checkContentCheck(responseText);
        this.checkUrl(url);
        ArrayList<Parm> parmList = new ArrayList<Parm>();
        if ("".equals(response)) {
            response = null;
        }
        parmList.add(new Parm("port", port));
        if (response != null) {
            parmList.add(new Parm("response", response));
        }
        parmList.add(new Parm("response text", responseText));
        parmList.add(new Parm("url", url));
        if (hostName != null) {
            parmList.add(new Parm("host-name", hostName));
        }
        if (user != null) {
            parmList.add(new Parm("user", user));
        }
        if (passwd != null) {
            parmList.add(new Parm("password", passwd));
        }
        if (agent != null) {
            parmList.add(new Parm("user-agent", agent));
        }
        return this.addService(serviceId, retry, timeout, interval, downTimeInterval, downTimeDuration, HTTP_MONITOR, HTTP_PLUGIN, parmList.toArray(new Parm[parmList.size()]));
    }

    public boolean addServiceHTTPS(String serviceId, int retry, int timeout, int interval, int downTimeInterval, int downTimeDuration, String hostName, int port, String response, String responseText, String url, String user, String passwd, String agent) throws MalformedURLException {
        this.validateSchedule(retry, timeout, interval, downTimeInterval, downTimeDuration);
        this.checkHostname(hostName);
        this.checkUsername(user);
        this.checkPassword(passwd);
        this.checkPort(port);
        this.checkResponseRange(response);
        this.checkContentCheck(responseText);
        this.checkUrl(url);
        if ("".equals(response)) {
            response = null;
        }
        ArrayList<Parm> parmList = new ArrayList<Parm>();
        parmList.add(new Parm("port", port));
        if (response != null) {
            parmList.add(new Parm("response", response));
        }
        parmList.add(new Parm("response text", responseText));
        parmList.add(new Parm("url", url));
        if (hostName != null) {
            parmList.add(new Parm("host-name", hostName));
        }
        if (user != null) {
            parmList.add(new Parm("user", user));
        }
        if (passwd != null) {
            parmList.add(new Parm("password", passwd));
        }
        if (agent != null) {
            parmList.add(new Parm("user-agent", agent));
        }
        return this.addService(serviceId, retry, timeout, interval, downTimeInterval, downTimeDuration, HTTPS_MONITOR, HTTPS_PLUGIN, parmList.toArray(new Parm[parmList.size()]));
    }

    public boolean addServiceDatabase(String serviceId, int retry, int timeout, int interval, int downTimeInterval, int downTimeDuration, String user, String password, String driver, String url) {
        this.validateSchedule(retry, timeout, interval, downTimeInterval, downTimeDuration);
        this.checkUsername(user);
        this.checkPassword(password);
        this.checkDriver(driver);
        this.checkUrl(url);
        Parm[] parm = new Parm[]{new Parm("driver", driver), new Parm("url", url), new Parm("user", user), new Parm("password", password)};
        return this.addService(serviceId, retry, timeout, interval, downTimeInterval, downTimeDuration, JDBC_MONITOR, JDBC_PLUGIN, parm);
    }

    public Map getServiceConfiguration(String pkgName, String serviceId) {
        int i;
        if (pkgName == null) {
            throw new NullPointerException("pkgName is null");
        }
        if (serviceId == null) {
            throw new NullPointerException("serviceId is null");
        }
        Package pkg = this.m_pollerConfig.getPackage(pkgName);
        if (pkg == null) {
            throw new IllegalArgumentException(pkgName + " is not a valid poller package name");
        }
        Service svc = this.m_pollerConfig.getServiceInPackage(serviceId, pkg);
        if (svc == null) {
            throw new IllegalArgumentException("Could not find service " + serviceId + " in package " + pkgName);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("serviceid", serviceId);
        m.put("interval", new Integer((int)svc.getInterval()));
        for (i = 0; i < svc.getParameterCount(); ++i) {
            Parameter param = svc.getParameter(i);
            String key = param.getKey();
            String valStr = param.getValue();
            Object val = valStr;
            if ("retry".equals(key)) {
                key = "retries";
                val = Integer.decode(valStr);
            } else if ("timeout".equals(key)) {
                val = Integer.decode(valStr);
            } else if ("port".equals(key)) {
                val = Integer.decode(valStr);
            } else if ("response".equals(key)) {
                val = valStr;
            } else if ("response text".equals(key)) {
                key = "response_text";
            } else if ("response-text".equals(key)) {
                key = "response_text";
            } else if ("host-name".equals(key)) {
                key = "hostname";
            } else if ("host name".equals(key)) {
                key = "hostname";
            } else if ("user-agent".equals(key)) {
                key = "agent";
            } else if ("basic-authentication".equals(key)) {
                int colon = valStr.indexOf(58);
                if (colon < 0) continue;
                String user = valStr.substring(0, colon);
                String passwd = valStr.substring(colon + 1);
                m.put("user", user);
                m.put("password", passwd);
                continue;
            }
            m.put(key, val);
        }
        for (i = 0; i < pkg.getDowntimeCount(); ++i) {
            String suffix;
            Downtime dt = pkg.getDowntime(i);
            String string = suffix = i == 0 ? "" : "" + i;
            if (!dt.hasEnd() && (dt.getDelete() == null || "false".equals(dt.getDelete()))) continue;
            m.put("downtime_interval" + suffix, new Integer((int)dt.getInterval()));
            int duration = !dt.hasEnd() ? Integer.MAX_VALUE : (int)(dt.getEnd() - dt.getBegin());
            m.put("downtime_duration" + suffix, new Integer(duration));
        }
        return m;
    }

    public void setCapsdConfig(CapsdConfig capsdConfig) {
        this.m_capsdConfig = capsdConfig;
    }

    public void setPollerConfig(PollerConfig pollerConfig) {
        this.m_pollerConfig = pollerConfig;
    }

    public void setEventManager(EventIpcManager eventManager) {
        this.m_eventManager = eventManager;
    }

    private CapsdDbSyncer getCapsdDbSyncer() {
        return this.m_capsdDbSyncer;
    }

    public void setCapsdDbSyncer(CapsdDbSyncer capsdDbSyncer) {
        this.m_capsdDbSyncer = capsdDbSyncer;
    }

    private static class Parm {
        String m_key;
        String m_val;

        Parm(String key, String val) {
            this.m_key = key;
            this.m_val = val;
        }

        Parm(String key, int val) {
            this.m_key = key;
            this.m_val = "" + val;
        }

        String getKey() {
            return this.m_key;
        }

        String getVal() {
            return this.m_val;
        }
    }
}

