/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseChecker {
    private String m_driverUrl;
    private String m_driverUser;
    private String m_driverPass;

    protected DatabaseChecker(String configFile) throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        InputSource dbIn = new InputSource(new FileInputStream(configFile));
        dbIn.setSystemId(configFile);
        DataSourceConfiguration m_database = (DataSourceConfiguration)Unmarshaller.unmarshal(DataSourceConfiguration.class, (InputSource)dbIn);
        for (JdbcDataSource jdbcDataSource : this.getJdbcDataSources(m_database)) {
            this.m_driverUrl = jdbcDataSource.getUrl();
            this.m_driverUser = jdbcDataSource.getUserName();
            this.m_driverPass = jdbcDataSource.getPassword();
            String driverCN = jdbcDataSource.getClassName();
            Class.forName(driverCN);
        }
    }

    private List<JdbcDataSource> getJdbcDataSources(DataSourceConfiguration m_database) {
        return m_database.getJdbcDataSourceCollection();
    }

    protected DatabaseChecker() throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        this(ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME).getPath());
    }

    public void check() throws SQLException {
        Connection c = DriverManager.getConnection(this.m_driverUrl, this.m_driverUser, this.m_driverPass);
        c.close();
    }

    public static void main(String[] argv) throws Exception {
        DatabaseChecker checker = new DatabaseChecker();
        checker.check();
    }
}

