/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;

class JavaMailerConfig {
    JavaMailerConfig() {
    }

    private static synchronized Properties getProperties() throws IOException {
        Properties properties = new Properties(System.getProperties());
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.JAVA_MAIL_CONFIG_FILE_NAME);
        FileInputStream in = new FileInputStream(configFile);
        properties.load(in);
        ((InputStream)in).close();
        return properties;
    }

    public static String getProperty(String name, String defaultVal) {
        try {
            return JavaMailerConfig.getProperties().getProperty(name, defaultVal);
        }
        catch (IOException e) {
            JavaMailerConfig.log().error((Object)("Unable to read property " + name + " returning defaultValue: " + defaultVal), (Throwable)e);
            return defaultVal;
        }
    }

    private static Category log() {
        return ThreadCategory.getInstance(JavaMailerConfig.class);
    }

    public static boolean getProperty(String name, boolean defaultVal) {
        return "true".equalsIgnoreCase(JavaMailerConfig.getProperty(name, defaultVal ? "true" : "false"));
    }

    public static int getProperty(String name, int defaultVal) {
        String val = JavaMailerConfig.getProperty(name, null);
        if (val != null) {
            try {
                return Integer.decode(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultVal;
    }

    public static long getProperty(String name, long defaultVal) {
        String val = JavaMailerConfig.getProperty(name, null);
        if (val != null) {
            try {
                return Long.decode(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultVal;
    }
}

