/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.ThreshdConfigManager;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Thresholder;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.threshd.BroadcastEventProcessor;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.ThresholdableService;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.Querier;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.springframework.dao.DataRetrievalFailureException;

public final class Threshd
extends AbstractServiceDaemon {
    private static final String SQL_RETRIEVE_INTERFACES = "SELECT nodeid,ipaddr FROM ifServices, service WHERE ifServices.serviceid = service.serviceid AND service.servicename = ?";
    private static final Threshd m_singleton = new Threshd();
    private List<ThresholdableService> m_thresholdableServices;
    private LegacyScheduler m_scheduler = null;
    private boolean m_schedulingCompleted = false;
    private EventProxy m_proxy;
    private BroadcastEventProcessor m_receiver;
    private static Map<String, ServiceThresholder> m_svcThresholders;
    private ThreshdConfigManager m_threshdConfig;

    Threshd() {
        super("OpenNMS.Threshd");
        m_svcThresholders = Collections.synchronizedMap(new TreeMap());
        this.m_thresholdableServices = Collections.synchronizedList(new LinkedList());
        this.m_proxy = new EventProxy(){

            public void send(Event e) {
                EventIpcManagerFactory.getIpcManager().sendNow(e);
            }

            public void send(Log l) {
                EventIpcManagerFactory.getIpcManager().sendNow(l);
            }
        };
    }

    protected void onInit() {
        this.log().debug((Object)"start: Initializing thresholding daemon");
        this.log().debug((Object)"start: Loading thresholders");
        this.initializeThresholders();
        this.initializeScheduler();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"start: Scheduling existing interfaces");
        }
        this.scheduleBackgroundInitTask();
        this.createBroadcastEventProcessor();
    }

    private void createBroadcastEventProcessor() {
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"start: Creating event broadcast event processor");
            }
            this.m_receiver = new BroadcastEventProcessor(this, this.m_thresholdableServices);
        }
        catch (Throwable t) {
            if (this.log().isEnabledFor((Priority)Level.FATAL)) {
                this.log().fatal((Object)"start: Failed to initialized the broadcast event receiver", t);
            }
            throw new UndeclaredThrowableException(t);
        }
    }

    private void scheduleBackgroundInitTask() {
        ReadyRunnable interfaceScheduler = new ReadyRunnable(){

            public boolean isReady() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Threshd.this.scheduleExistingInterfaces();
                }
                catch (DataRetrievalFailureException sqlE) {
                    Threshd.this.log().error((Object)"start: Failed to schedule existing interfaces", (Throwable)sqlE);
                }
                finally {
                    Threshd.this.setSchedulingCompleted(true);
                }
            }
        };
        this.m_scheduler.schedule(interfaceScheduler, 0L);
    }

    private void initializeScheduler() {
        try {
            this.log().debug((Object)"start: Creating threshd scheduler");
            this.m_scheduler = new LegacyScheduler("Threshd", this.m_threshdConfig.getConfiguration().getThreads());
        }
        catch (RuntimeException e) {
            this.log().fatal((Object)"start: Failed to create threshd scheduler", (Throwable)e);
            throw e;
        }
    }

    private void initializeThresholders() {
        Enumeration eiter = this.m_threshdConfig.getConfiguration().enumerateThresholder();
        while (eiter.hasMoreElements()) {
            Thresholder thresholder = (Thresholder)eiter.nextElement();
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("start: Loading thresholder " + thresholder.getService() + ", classname " + thresholder.getClassName()));
                }
                Class<?> tc = Class.forName(thresholder.getClassName());
                ServiceThresholder st = (ServiceThresholder)tc.newInstance();
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("svcName", thresholder.getService());
                st.initialize(properties);
                m_svcThresholders.put(thresholder.getService(), st);
            }
            catch (Throwable t) {
                this.log().warn((Object)("start: Failed to load thresholder " + thresholder.getClassName() + " for service " + thresholder.getService()), t);
            }
        }
    }

    public void reinitializeThresholders() {
        for (String key : m_svcThresholders.keySet()) {
            ServiceThresholder thresholder = m_svcThresholders.get(key);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("reinitializeThresholders: About to reinitialize thresholder " + key));
            }
            thresholder.reinitialize();
        }
    }

    protected void onStart() {
        this.log().debug((Object)"start: Initializing thresholding daemon");
        try {
            this.log().debug((Object)"start: Starting threshd scheduler");
            this.m_scheduler.start();
        }
        catch (RuntimeException e) {
            this.log().fatal((Object)"start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
        this.log().debug((Object)"start: Threshd running");
    }

    protected void onStop() {
        this.m_scheduler.stop();
        this.m_receiver.close();
        this.m_scheduler = null;
    }

    protected void onPause() {
        this.m_scheduler.pause();
    }

    protected void onResume() {
        this.m_scheduler.resume();
    }

    public static Threshd getInstance() {
        return m_singleton;
    }

    public LegacyScheduler getScheduler() {
        return this.m_scheduler;
    }

    public EventProxy getEventProxy() {
        return this.m_proxy;
    }

    public ServiceThresholder getServiceThresholder(String svcName) {
        return m_svcThresholders.get(svcName);
    }

    private void scheduleExistingInterfaces() {
        for (final String svcName : m_svcThresholders.keySet()) {
            Querier querier = new Querier(DataSourceFactory.getDataSource(), SQL_RETRIEVE_INTERFACES){

                public void processRow(ResultSet rs) throws SQLException {
                    int nodeId = rs.getInt(1);
                    String ipAddress = rs.getString(2);
                    Threshd.this.log().debug((Object)("Scheduling service nodeId/ipAddress/svcName " + nodeId + '/' + ipAddress + '/' + svcName));
                    Threshd.this.scheduleService(nodeId, ipAddress, svcName, true);
                }
            };
            querier.execute(svcName);
        }
    }

    void scheduleService(int nodeId, String ipAddress, String svcName, boolean existing) {
        Enumeration epkgs = this.m_threshdConfig.getConfiguration().enumeratePackage();
        while (epkgs.hasMoreElements()) {
            Package pkg = (Package)epkgs.nextElement();
            if (!this.m_threshdConfig.serviceInPackageAndEnabled(svcName, pkg)) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("scheduleService: address/service: " + ipAddress + "/" + svcName + " not scheduled, service is not enabled or does not exist in package: " + pkg.getName()));
                continue;
            }
            this.log().debug((Object)("scheduleService: checking ipaddress " + ipAddress + " for inclusion in pkg " + pkg.getName()));
            boolean foundInPkg = this.m_threshdConfig.interfaceInPackage(ipAddress, pkg);
            if (!foundInPkg && !existing) {
                this.m_threshdConfig.rebuildPackageIpListMap();
                foundInPkg = this.m_threshdConfig.interfaceInPackage(ipAddress, pkg);
            }
            if (!foundInPkg) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("scheduleInterface: address/service: " + ipAddress + "/" + svcName + " not scheduled, interface does not belong to package: " + pkg.getName()));
                continue;
            }
            this.log().debug((Object)("scheduleService: ipaddress " + ipAddress + " IS in pkg " + pkg.getName()));
            if (!existing && this.alreadyScheduled(ipAddress, pkg.getName())) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("scheduleService: ipAddr/pkgName " + ipAddress + "/" + pkg.getName() + " already in thresholdable service list, skipping."));
                continue;
            }
            try {
                ThresholdableService tSvc = null;
                tSvc = new ThresholdableService(this, nodeId, InetAddress.getByName(ipAddress), svcName, pkg);
                ServiceThresholder thresholder = this.getServiceThresholder(svcName);
                thresholder.initialize(tSvc, tSvc.getPropertyMap());
                this.m_thresholdableServices.add(tSvc);
                this.m_scheduler.schedule(tSvc, tSvc.getInterval());
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("scheduleService: " + nodeId + "/" + ipAddress + " scheduled for " + svcName + " threshold checking"));
            }
            catch (UnknownHostException ex) {
                this.log().error((Object)("scheduleService: Failed to schedule interface " + ipAddress + " for service " + svcName + ", illegal address"), (Throwable)ex);
            }
            catch (RuntimeException rE) {
                this.log().warn((Object)("scheduleService: Unable to schedule " + ipAddress + " for service " + svcName + ", reason: " + rE.getMessage()), (Throwable)rE);
            }
            catch (Throwable t) {
                this.log().error((Object)("scheduleService: Uncaught exception, failed to schedule interface " + ipAddress + " for service " + svcName), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyScheduled(String ipAddress, String pkgName) {
        List<ThresholdableService> list = this.m_thresholdableServices;
        synchronized (list) {
            for (ThresholdableService tSvc : this.m_thresholdableServices) {
                InetAddress addr = (InetAddress)tSvc.getAddress();
                if (!addr.getHostAddress().equals(ipAddress) || !tSvc.getPackageName().equals(pkgName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSchedulingCompleted() {
        return this.m_schedulingCompleted;
    }

    public void setSchedulingCompleted(boolean schedulingCompleted) {
        this.m_schedulingCompleted = schedulingCompleted;
    }

    public void refreshServicePackages() {
        for (ThresholdableService thisService : this.m_thresholdableServices) {
            thisService.refreshPackage();
        }
    }

    public void setThreshdConfig(ThreshdConfigManager threshdConfig) {
        this.m_threshdConfig = threshdConfig;
    }

    public Package getPackage(String name) {
        return this.m_threshdConfig.getPackage(name);
    }
}

