/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.StatisticsDaemonConfigDao;
import org.opennms.netmgt.dao.castor.statsd.PackageReport;
import org.opennms.netmgt.dao.castor.statsd.Report;
import org.opennms.netmgt.dao.castor.statsd.StatsdPackage;
import org.opennms.netmgt.statsd.ReportDefinition;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDefinitionBuilder
implements InitializingBean {
    private StatisticsDaemonConfigDao m_statsdConfigDao;

    public Collection<ReportDefinition> buildReportDefinitions() {
        HashSet<ReportDefinition> reportDefinitions = new HashSet<ReportDefinition>();
        for (StatsdPackage pkg : this.m_statsdConfigDao.getPackages()) {
            for (PackageReport packageReport : pkg.getReports()) {
                Class<?> clazz;
                Report report = packageReport.getReport();
                if (!packageReport.isEnabled()) {
                    this.log().debug((Object)("skipping report '" + report.getName() + "' in package '" + pkg.getName() + "' because the report is not enabled"));
                }
                try {
                    clazz = Class.forName(report.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new DataAccessResourceFailureException("Could not find class '" + report.getClassName() + "'; nested exception: " + e, (Throwable)e);
                }
                ReportDefinition reportDef = new ReportDefinition();
                reportDef.setReport(packageReport);
                reportDef.setReportClass(clazz);
                BeanWrapperImpl bw = new BeanWrapperImpl((Object)reportDef);
                bw.setPropertyValues((Map)packageReport.getAggregateParameters());
                reportDef.afterPropertiesSet();
                reportDefinitions.add(reportDef);
            }
        }
        return reportDefinitions;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_statsdConfigDao != null ? 1 : 0) != 0, (String)"property statsdConfigDao must be set to a non-null value");
    }

    public StatisticsDaemonConfigDao getStatsdConfigDao() {
        return this.m_statsdConfigDao;
    }

    public void setStatsdConfigDao(StatisticsDaemonConfigDao statsdConfigDao) {
        this.m_statsdConfigDao = statsdConfigDao;
    }
}

