/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.queued;

import java.util.Collection;
import java.util.Set;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queued
extends AbstractServiceDaemon
implements EventListener {
    private EventIpcManager m_eventMgr;
    private RrdStrategy m_rrdStrategy;

    public Queued() {
        super("OpenNMS.Queued");
    }

    public void setEventIpcManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public void setRrdStrategy(RrdStrategy rrdStrategy) {
        this.m_rrdStrategy = rrdStrategy;
    }

    @Override
    protected void onInit() {
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"setEventIpcManager must be set");
        Assert.state((this.m_rrdStrategy != null ? 1 : 0) != 0, (String)"rrdStrategy must be set");
        this.m_eventMgr.addEventListener((EventListener)this, "uei.opennms.org/internal/promoteQueueData");
    }

    @Override
    public void onEvent(Event e) {
        String fileList = EventUtils.getParm(e, "filesToPromote");
        Set files = StringUtils.commaDelimitedListToSet((String)fileList);
        this.logFilePromotion(files);
        this.m_rrdStrategy.promoteEnqueuedFiles((Collection)files);
    }

    private void logFilePromotion(Set<String> files) {
        if (!this.log().isDebugEnabled()) {
            return;
        }
        for (String file : files) {
            this.debugf("Promoting file: %s", file);
        }
    }

    private void debugf(String format, Object ... args) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)String.format(format, args));
        }
    }
}

