/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableElement;
import org.opennms.netmgt.poller.pollables.PollableVisitor;

public abstract class PollableContainer
extends PollableElement {
    private Map m_members = new HashMap();

    public PollableContainer(PollableContainer parent) {
        super(parent);
    }

    protected synchronized PollableElement getMember(Object key) {
        return (PollableElement)this.m_members.get(key);
    }

    protected synchronized int getMemberCount() {
        return this.m_members.size();
    }

    protected synchronized Collection getMembers() {
        return new LinkedList(this.m_members.values());
    }

    protected abstract Object createMemberKey(PollableElement var1);

    protected synchronized void addMember(PollableElement member) {
        Object key = this.createMemberKey(member);
        this.m_members.put(key, member);
    }

    public synchronized void removeMember(PollableElement member) {
        Object key = this.createMemberKey(member);
        this.m_members.remove(key);
    }

    public void deleteMember(PollableElement member) {
        this.removeMember(member);
        if (this.m_members.size() == 0) {
            this.delete();
        }
    }

    public void delete() {
        Runnable r = new Runnable(){

            public void run() {
                Collection members = PollableContainer.this.getMembers();
                for (PollableElement member : members) {
                    member.delete();
                }
                PollableContainer.super.delete();
            }
        };
        this.withTreeLock(r);
    }

    public void visit(PollableVisitor v) {
        this.visitThis(v);
        this.visitMembers(v);
    }

    protected void visitThis(PollableVisitor v) {
        super.visitThis(v);
        v.visitContainer(this);
    }

    protected void visitMembers(PollableVisitor v) {
        for (PollableElement element : this.getMembers()) {
            element.visit(v);
        }
    }

    protected void forEachMember(Iter iter) {
        for (PollableElement element : this.getMembers()) {
            iter.forEachElement(element);
        }
    }

    public void recalculateStatus() {
        Runnable r = new Runnable(){

            public void run() {
                SimpleIter iter = new SimpleIter((Object)PollStatus.down()){

                    public void forEachElement(PollableElement elem) {
                        elem.recalculateStatus();
                        if (elem.getStatus().isUp()) {
                            this.setResult(PollStatus.up());
                        }
                    }
                };
                PollableContainer.this.forEachMember(iter);
                PollableContainer.this.updateStatus((PollStatus)iter.getResult());
            }
        };
        this.withTreeLock(r);
    }

    public void resetStatusChanged() {
        Runnable r = new Runnable(){

            public void run() {
                PollableContainer.super.resetStatusChanged();
                Iter iter = new Iter(){

                    public void forEachElement(PollableElement elem) {
                        elem.resetStatusChanged();
                    }
                };
                PollableContainer.this.forEachMember(iter);
            }
        };
        this.withTreeLock(r);
    }

    PollableElement findMemberWithDescendent(PollableElement elem) {
        PollableElement member;
        for (member = elem; member != null && member.getParent() != this; member = member.getParent()) {
        }
        return member;
    }

    protected PollStatus poll(final PollableElement elem) {
        final PollStatus[] retVal = new PollStatus[1];
        Runnable r = new Runnable(){

            public void run() {
                PollableElement member = PollableContainer.this.findMemberWithDescendent(elem);
                PollStatus memberStatus = member.poll(elem);
                if (memberStatus.isUp() != PollableContainer.this.getStatus().isUp() && member.isStatusChanged()) {
                    PollableContainer.this.updateStatus(PollableContainer.this.pollRemainingMembers(member));
                }
                retVal[0] = PollableContainer.this.getStatus();
            }
        };
        elem.withTreeLock(r);
        return retVal[0];
    }

    public PollStatus pollRemainingMembers(final PollableElement member) {
        SimpleIter iter = new SimpleIter(member.getStatus()){

            public void forEachElement(PollableElement elem) {
                if (elem != member && elem.poll().isUp()) {
                    this.setResult(PollStatus.up());
                }
            }
        };
        this.forEachMember(iter);
        return (PollStatus)iter.getResult();
    }

    public PollStatus getMemberStatus() {
        SimpleIter iter = new SimpleIter(PollStatus.down()){

            public void forEachElement(PollableElement elem) {
                if (elem.getStatus().isUp()) {
                    this.setResult(PollStatus.up());
                }
            }
        };
        this.forEachMember(iter);
        return (PollStatus)iter.getResult();
    }

    public PollStatus poll() {
        PollableElement leaf = this.selectPollElement();
        if (leaf == null) {
            return PollStatus.up();
        }
        return this.poll(leaf);
    }

    public PollableElement selectPollElement() {
        if (this.getMemberCount() == 0) {
            return null;
        }
        PollableElement member = (PollableElement)this.getMembers().iterator().next();
        return member.selectPollElement();
    }

    public void processStatusChange(final Date date) {
        Runnable r = new Runnable(){

            public void run() {
                if (PollableContainer.this.isStatusChanged()) {
                    PollableContainer.super.processStatusChange(date);
                } else if (PollableContainer.this.getStatus().isUp()) {
                    PollableContainer.this.processMemberStatusChanges(date);
                }
            }
        };
        this.withTreeLock(r);
    }

    public void processMemberStatusChanges(final Date date) {
        Iter iter = new Iter(){

            public void forEachElement(PollableElement elem) {
                elem.processStatusChange(date);
            }
        };
        this.forEachMember(iter);
    }

    protected void processResolution(PollEvent resolvedCause, PollEvent resolution) {
        super.processResolution(resolvedCause, resolution);
        this.processLingeringMemberCauses(resolvedCause, resolution);
    }

    private void processLingeringMemberCauses(final PollEvent resolvedCause, final PollEvent resolution) {
        Iter iter = new Iter(){

            public void forEachElement(PollableElement elem) {
                elem.processLingeringCauses(resolvedCause, resolution);
            }
        };
        this.forEachMember(iter);
    }

    protected void processCause(final PollEvent cause) {
        super.processCause(cause);
        Iter iter = new Iter(){

            public void forEachElement(PollableElement elem) {
                elem.processCause(cause);
            }
        };
        this.forEachMember(iter);
    }

    protected void resolveAllOutages(final PollEvent resolvedCause, final PollEvent resolution) {
        super.resolveAllOutages(resolvedCause, resolution);
        Iter iter = new Iter(){

            public void forEachElement(PollableElement elem) {
                if (!PollableContainer.this.hasOpenOutage()) {
                    elem.resolveAllOutages(resolvedCause, resolution);
                }
            }
        };
        this.forEachMember(iter);
    }

    protected abstract class SimpleIter
    implements Iter {
        private Object result;

        public SimpleIter(Object initial) {
            this.result = initial;
        }

        public SimpleIter() {
            this(null);
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object newResult) {
            this.result = newResult;
        }
    }

    protected static interface Iter {
        public void forEachElement(PollableElement var1);
    }
}

