/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.CollectionMath;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.ping.Pinger;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.utils.ParameterMap;

@Distributable(value={DistributionContext.DAEMON})
public final class StrafePingMonitor
extends IPv4Monitor {
    private static final int DEFAULT_MULTI_PING_COUNT = 20;
    private static final long DEFAULT_PING_INTERVAL = 50L;
    private static final int DEFAULT_FAILURE_PING_COUNT = 20;

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        PollStatus serviceStatus = PollStatus.unavailable();
        InetAddress host = (InetAddress)iface.getAddress();
        ArrayList responseTimes = null;
        try {
            long timeout = ParameterMap.getKeyedLong(parameters, "timeout", 800L);
            int count = ParameterMap.getKeyedInteger(parameters, "ping-count", 20);
            long pingInterval = ParameterMap.getKeyedLong(parameters, "wait-interval", 50L);
            int failurePingCount = ParameterMap.getKeyedInteger(parameters, "failure-ping-count", 20);
            responseTimes = new ArrayList(Pinger.parallelPing((InetAddress)host, (int)count, (long)timeout, (long)pingInterval));
            if (CollectionMath.countNull(responseTimes) >= (long)failurePingCount) {
                return PollStatus.unavailable((String)("the failure ping count (" + failurePingCount + ") was reached"));
            }
            serviceStatus = PollStatus.available();
            Collections.sort(responseTimes, new Comparator<Number>(){

                @Override
                public int compare(Number arg0, Number arg1) {
                    if (arg0 == null) {
                        return -1;
                    }
                    if (arg1 == null) {
                        return 1;
                    }
                    if (arg0.doubleValue() == arg1.doubleValue()) {
                        return 0;
                    }
                    return arg0.doubleValue() < arg1.doubleValue() ? -1 : 1;
                }
            });
            LinkedHashMap<String, Object> returnval = new LinkedHashMap<String, Object>();
            for (int i = 0; i < responseTimes.size(); ++i) {
                returnval.put("ping" + (i + 1), responseTimes.get(i));
            }
            returnval.put("loss", CollectionMath.countNull(responseTimes));
            returnval.put("median", CollectionMath.median(responseTimes));
            returnval.put("response-time", CollectionMath.average(responseTimes));
            serviceStatus.setProperties(returnval);
        }
        catch (Exception e) {
            log.debug((Object)("failed to ping " + host), (Throwable)e);
        }
        return serviceStatus;
    }
}

