/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.opennms.core.utils.Base64;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.monitors.TimeoutTracker;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public class HttpMonitor
extends IPv4Monitor {
    private static final int[] DEFAULT_PORTS = new int[]{80, 8080, 8888};
    private static final int DEFAULT_RETRY = 0;
    private static final String DEFAULT_URL = "/";
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        String cmd = this.buildCommand(iface, parameters);
        int serviceStatus = 2;
        String reason = null;
        Double responseTime = null;
        int currentPort = -1;
        for (int portIndex = 0; portIndex < this.getPorts(parameters).length && serviceStatus != 1; ++portIndex) {
            currentPort = this.getPorts(parameters)[portIndex];
            TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Port = " + currentPort + ", Address = " + this.getIpv4Addr(iface) + ", " + tracker));
            }
            tracker.reset();
            while (tracker.shouldRetry() && serviceStatus != 1) {
                block52: {
                    Socket socket = null;
                    try {
                        tracker.startAttempt();
                        socket = this.createSocket(iface, currentPort, tracker.getSoTimeout());
                        socket.connect(new InetSocketAddress(this.getIpv4Addr(iface), currentPort), tracker.getConnectionTimeout());
                        socket = this.wrapSocket(socket);
                        this.log().debug((Object)("HttpMonitor: connected to host: " + this.getIpv4Addr(iface) + " on port: " + currentPort));
                        serviceStatus = 3;
                        socket.getOutputStream().write(cmd.getBytes());
                        BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        String line = lineRdr.readLine();
                        if (line == null) break block52;
                        responseTime = tracker.elapsedTimeInMillis();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug((Object)("poll: response= " + line));
                            this.log().debug((Object)("poll: responseTime= " + responseTime + "ms"));
                        }
                        if (line.startsWith("HTTP/")) {
                            StringTokenizer t = new StringTokenizer(line);
                            t.nextToken();
                            int serverResponseValue = -1;
                            try {
                                serverResponseValue = Integer.parseInt(t.nextToken());
                            }
                            catch (NumberFormatException nfE) {
                                this.log().info((Object)("Error converting response code from host = " + this.getIpv4Addr(iface) + ", response = " + line));
                            }
                            if (SnmpPeerFactory.matchNumericListOrRange(String.valueOf(serverResponseValue), this.getResponse(parameters))) {
                                serviceStatus = 1;
                            } else {
                                serviceStatus = 2;
                                StringBuffer sb = new StringBuffer();
                                sb.append("HTTP response value: ");
                                sb.append(serverResponseValue);
                                sb.append(". Expecting: ");
                                sb.append(this.getResponse(parameters));
                                sb.append(".");
                                reason = sb.toString();
                            }
                        }
                        if (serviceStatus == 1 && this.getResponseText(parameters) != null && this.getResponseText(parameters).length() > 0) {
                            do {
                                line = lineRdr.readLine();
                                if (!this.isVerbose(parameters)) continue;
                                this.log().debug((Object)("\theader: " + line));
                            } while (line != null && line.length() != 0);
                            if (line != null) {
                                boolean bResponseTextFound = false;
                                int nullCount = 0;
                                do {
                                    line = lineRdr.readLine();
                                    if (this.isVerbose(parameters)) {
                                        this.log().debug((Object)("\tbody: " + line));
                                    }
                                    if (line != null) {
                                        if (this.getResponseText(parameters).charAt(0) == '~') {
                                            if (!line.matches(this.getResponseText(parameters).substring(1))) continue;
                                            bResponseTextFound = true;
                                            continue;
                                        }
                                        int responseIndex = line.indexOf(this.getResponseText(parameters));
                                        if (responseIndex == -1) continue;
                                        bResponseTextFound = true;
                                        continue;
                                    }
                                    ++nullCount;
                                } while (nullCount < 2 && !bResponseTextFound);
                                if (!bResponseTextFound) {
                                    serviceStatus = 2;
                                    reason = "Matching text: [" + this.getResponseText(parameters) + "] not found in body of HTTP response";
                                }
                            }
                        }
                    }
                    catch (NoRouteToHostException e) {
                        this.log().warn((Object)("checkStatus: No route to host exception for address " + this.getIpv4Addr(iface) + ": " + e.getMessage()));
                        portIndex = this.getPorts(parameters).length;
                        reason = "No route to host exception";
                    }
                    catch (InterruptedIOException e) {
                        this.log().info((Object)("checkStatus: did not connect to host with " + tracker));
                        reason = "HTTP connection timeout";
                    }
                    catch (ConnectException e) {
                        this.log().warn((Object)("Connection exception for " + this.getIpv4Addr(iface) + ":" + this.getPorts(parameters)[portIndex] + ":" + e.getMessage()));
                        reason = "HTTP connection exception on port: " + this.getPorts(parameters)[portIndex] + ": " + e.getMessage();
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        this.log().warn((Object)("IOException while polling address " + this.getIpv4Addr(iface)), (Throwable)e);
                        reason = "IOException while polling address: " + this.getIpv4Addr(iface) + ": " + e.getMessage();
                    }
                    finally {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (IOException e) {
                            e.fillInStackTrace();
                            this.log().warn((Object)"Error closing socket connection", (Throwable)e);
                        }
                    }
                }
                tracker.nextAttempt();
            }
        }
        if (serviceStatus == 2) {
            StringBuffer testedPorts = new StringBuffer();
            for (int i = 0; i < this.getPorts(parameters).length; ++i) {
                if (i == 0) {
                    testedPorts.append(this.getPorts(parameters)[0]);
                    continue;
                }
                testedPorts.append(',').append(this.getPorts(parameters)[i]);
            }
            parameters.put("qualifier", testedPorts.toString());
            reason = reason + "/Ports: " + testedPorts.toString();
            this.log().debug((Object)("checkStatus: Reason: \"" + reason + "\""));
            return PollStatus.unavailable((String)reason);
        }
        if (serviceStatus == 1) {
            parameters.put("qualifier", Integer.toString(currentPort));
            return PollStatus.available(responseTime);
        }
        return PollStatus.get((int)serviceStatus, reason);
    }

    protected Socket wrapSocket(Socket socket) throws IOException {
        return socket;
    }

    protected Socket createSocket(NetworkInterface iface, int currentPort, int soTimeout) throws IOException, SocketException {
        Socket socket = new Socket();
        socket.setSoTimeout(soTimeout);
        return socket;
    }

    private boolean isVerbose(Map<String, String> parameters) {
        String verbose = ParameterMap.getKeyedString(parameters, "verbose", null);
        return verbose != null && verbose.equalsIgnoreCase("true");
    }

    private String buildCommand(NetworkInterface iface, Map<String, String> parameters) {
        TreeMap<String, String> sortedParameters = new TreeMap<String, String>(parameters);
        String cmd = "GET " + this.getUrl(parameters) + " HTTP/1.1\r\n";
        cmd = cmd + "Connection: CLOSE \r\n";
        cmd = this.getVirtualHost(parameters) != null ? cmd + "Host: " + this.getVirtualHost(parameters) + "\r\n" : cmd + "Host: " + this.getIpv4Addr(iface).getHostName() + "\r\n";
        cmd = cmd + "User-Agent: " + this.getUserAgent(parameters) + "\r\n";
        if (this.getBasicAuthentication(parameters) != null) {
            cmd = cmd + "Authorization: Basic " + this.getBasicAuthentication(parameters) + "\r\n";
        }
        for (String parmKey : sortedParameters.keySet()) {
            if (!parmKey.matches("header[0-9]+$")) continue;
            cmd = cmd + this.getHeader(parameters, parmKey) + "\r\n";
        }
        cmd = cmd + "\r\n";
        this.log().debug((Object)("checkStatus: cmd:\n" + cmd));
        return cmd;
    }

    private String getUserAgent(Map<String, String> parameters) {
        String agent = ParameterMap.getKeyedString(parameters, "user-agent", null);
        if (agent == null || "".equals(agent)) {
            return "OpenNMS HttpMonitor";
        }
        return agent;
    }

    protected String getBasicAuthentication(Map<String, String> parameters) {
        String credentials = ParameterMap.getKeyedString(parameters, "basic-authentication", null);
        if (credentials != null && !"".equals(credentials)) {
            return new String(Base64.encodeBase64((byte[])credentials.getBytes()));
        }
        String user = ParameterMap.getKeyedString(parameters, "user", null);
        if (user == null || "".equals(user)) {
            return null;
        }
        String passwd = ParameterMap.getKeyedString(parameters, "password", "");
        return new String(Base64.encodeBase64((byte[])(user + ":" + passwd).getBytes()));
    }

    private InetAddress getIpv4Addr(NetworkInterface iface) {
        return (InetAddress)iface.getAddress();
    }

    private String getHeader(Map<String, String> parameters, String key) {
        return ParameterMap.getKeyedString(parameters, key, null);
    }

    private String getVirtualHost(Map<String, String> parameters) {
        String virtualHost = ParameterMap.getKeyedString(parameters, "host-name", null);
        if (virtualHost == null || "".equals(virtualHost)) {
            virtualHost = ParameterMap.getKeyedString(parameters, "host name", null);
        }
        if (virtualHost == null || "".equals(virtualHost)) {
            return null;
        }
        return virtualHost;
    }

    private String getResponseText(Map<String, String> parameters) {
        String responseText = ParameterMap.getKeyedString(parameters, "response-text", null);
        if (responseText == null) {
            responseText = ParameterMap.getKeyedString(parameters, "response text", null);
        }
        return responseText;
    }

    private String getResponse(Map<String, String> parameters) {
        return ParameterMap.getKeyedString(parameters, "response", this.getDefaultResponseRange(this.getUrl(parameters)));
    }

    private String getUrl(Map<String, String> parameters) {
        return ParameterMap.getKeyedString(parameters, "url", DEFAULT_URL);
    }

    protected int[] getPorts(Map<String, String> parameters) {
        return ParameterMap.getKeyedIntegerArray(parameters, "port", DEFAULT_PORTS);
    }

    private String getDefaultResponseRange(String url) {
        if (url == null || url.equals(DEFAULT_URL)) {
            return "100-499";
        }
        return "100-399";
    }
}

